package ru.yandex.autotests.directapi.reports.orderby;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.OrderByMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by onotole on 19.07.16.
 * https://st.yandex-team.ru/TESTIRT-9739
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Description("проверка работы OrderBy, тесты, которые должны упасть")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class OrderByNegativeTest {

    public static final String CLIENT = ReportsLogins.STAT_CLIENT_FOR_SHARDING;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public FieldEnum fieldEnum;

    @Parameterized.Parameter(1)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "FieldNames = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{ // поставить правильные описания ошибок после https://st.yandex-team.ru/DIRECT-56349
                {FieldEnum.CRITERIA_ID, new Api5Error(4000, Api5ErrorDetails.REPORTS_UNSUPPORTED_FIELD, "OrderBy.Field", "CriteriaId")},
                {FieldEnum.KEYWORD, new Api5Error(4000, Api5ErrorDetails.REPORTS_UNSUPPORTED_FIELD, "OrderBy.Field", "Keyword")},
                {FieldEnum.AUDIENCE_TARGET_ID, new Api5Error(4000, Api5ErrorDetails.REPORTS_UNSUPPORTED_FIELD, "OrderBy.Field", "AudienceTargetId")},
                {FieldEnum.DYNAMIC_TEXT_AD_TARGET_ID, new Api5Error(4000, Api5ErrorDetails.REPORTS_UNSUPPORTED_FIELD, "OrderBy.Field", "DynamicTextAdTargetId")},
                {FieldEnum.SMART_BANNER_FILTER_ID, new Api5Error(4000, Api5ErrorDetails.REPORTS_UNSUPPORTED_FIELD, "OrderBy.Field", "SmartBannerFilterId")},
                {FieldEnum.CRITERIA, new Api5Error(4000, Api5ErrorDetails.REPORTS_UNSUPPORTED_FIELD, "OrderBy.Field", "Criteria")},
//                {FieldEnum.PERFORMANCE_COVERAGE, new Api5Error(4000, Api5ErrorDetails.REPORTS_UNSUPPORTED_FIELD, "OrderBy.Field", "Keyword")}, будет переименовано в рамках DIRECT-56577
        });
    }

    @Test
    public void orderByUnsupportedFieldTest() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap())
                .withFieldNames(FieldEnum.CAMPAIGN_ID)
                .withOrderBy(new OrderByMap()
                        .withField(fieldEnum))
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.TODAY)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);
        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap, expectedError);
    }
}
