package ru.yandex.autotests.directapi.reports.page;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.apache.commons.lang.WordUtils;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.PageMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by onotole on 20.07.16.
 * https://st.yandex-team.ru/TESTIRT-9738
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@RunWith(Parameterized.class)
@Description("проверка работы Page, негативные сценарии")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
public class NegativeTest {
    public static final String CLIENT = ReportsLogins.STAT_CLIENT_FOR_SHARDING;

    @Parameterized.Parameter(0)
    public long limit;

    @Parameterized.Parameter(1)
    public Api5Error api5Error;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][] {
                {0L, new Api5Error(4002, Api5ErrorDetails.ONLY_POSITIVE_VALUE_FOR_THIS_PARAMETER, WordUtils.capitalize(PageMap.LIMIT))},
                {-1L, new Api5Error(4002, Api5ErrorDetails.ONLY_POSITIVE_VALUE_FOR_THIS_PARAMETER, WordUtils.capitalize(PageMap.LIMIT))},
                {Long.MAX_VALUE, new Api5Error(4002, Api5ErrorDetails.LIMIT_CANNOT_BE_MORE, Integer.MAX_VALUE)}
        });
    }

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    public void ReportLimitedByBadNumberOfLines() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap())
                .withFieldNames(FieldEnum.CAMPAIGN_ID, FieldEnum.AGE, FieldEnum.AD_GROUP_ID, FieldEnum.AVG_CLICK_POSITION, FieldEnum.CRITERIA_TYPE)
                .withPage(new PageMap().withLimit(limit))
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.TODAY)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);

        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap, api5Error);
    }
}
