package ru.yandex.autotests.directapi.reports.page;

import com.yandex.direct.api.v5.general.AgeRangeEnum;
import com.yandex.direct.api.v5.general.SortOrderEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.*;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.*;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.lessThanOrEqualTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 20.07.16.
 * https://st.yandex-team.ru/TESTIRT-9738
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Description("проверка работы Page, основные случаи")
@Features(ReportsFeatures.ONLINE_CUSTOM_REPORT)
@RunWith(Parameterized.class)
public class ReportLimitedByPagesTest {
    public static final String CLIENT = ReportsLogins.STAT_CLIENT_FOR_SHARDING;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public Long pageLimit;

    @Parameterized.Parameters(name = "limit = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][] {
                {1L},
                {100L},
                {10000L},
                {1000000L}
        });
    }

    @Test
    public void pageWithoutOrderBy() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap())
                .withFieldNames(FieldEnum.CAMPAIGN_ID, FieldEnum.AGE, FieldEnum.AD_GROUP_ID,
                        FieldEnum.AVG_CLICK_POSITION, FieldEnum.CRITERIA_TYPE, FieldEnum.CLICK_TYPE, FieldEnum.DEVICE)
                .withPage(new PageMap().withLimit(pageLimit))
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.ALL_TIME)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assertThat("page отработал и вернулось ожидаемое количество строк (меньше либо равно, чем задано в ограничении)", (long) reportsData.getReportsLines().size(),
                lessThanOrEqualTo(pageLimit));
    }

    @Test
    public void pageWithOrderBy() {
        Boolean isOrderCorrect = true;
        ReportsLine previousLine;
        ReportsLine currentLine;

        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap())
                .withFieldNames(FieldEnum.CAMPAIGN_ID, FieldEnum.AGE, FieldEnum.AD_GROUP_ID,
                        FieldEnum.AVG_CLICK_POSITION, FieldEnum.CRITERIA_TYPE, FieldEnum.CLICK_TYPE, FieldEnum.DEVICE)
                .withPage(new PageMap().withLimit(pageLimit))
                .withOrderBy(new OrderByMap()
                        .withField(FieldEnum.AD_GROUP_ID)
                        .withSortOrder(SortOrderEnum.DESCENDING))
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.ALL_TIME)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assumeThat("page отработал и вернулось ожидаемое количество строк (меньше либо равно, чем задано в ограничении)", (long) reportsData.getReportsLines().size(),
                lessThanOrEqualTo(pageLimit));

        previousLine = reportsData.getReportsLines().get(0);
        for (int i = 1; i < reportsData.getReportsLines().size(); i++) {
            currentLine = reportsData.getReportsLines().get(i);
            if (currentLine.getAdGroupId() > previousLine.getAdGroupId()) {
                isOrderCorrect = false;
            }
            previousLine = currentLine;
        }
        assertThat("данные репорта вернулись в правильно отсортированном порядке", isOrderCorrect, equalTo(true));
    }

    @Test
    public void pageWithOrderByAndFilter() {
        Boolean isOrderCorrect = true;
        ReportsLine previousLine;
        ReportsLine currentLine;
        String filterValue = AgeRangeEnum.AGE_25_34.value();

        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withFilter(new FilterItemMap()
                                .withField(FieldEnum.AGE)
                                .withOperator(FilterOperatorEnum.EQUALS)
                                .withValues(filterValue)
                        ))
                .withFieldNames(FieldEnum.CAMPAIGN_ID, FieldEnum.AGE, FieldEnum.AD_GROUP_ID,
                        FieldEnum.AVG_CLICK_POSITION, FieldEnum.CRITERIA_TYPE, FieldEnum.CLICK_TYPE, FieldEnum.DEVICE)
                .withPage(new PageMap().withLimit(pageLimit))
                .withOrderBy(new OrderByMap()
                        .withField(FieldEnum.AD_GROUP_ID)
                        .withSortOrder(SortOrderEnum.DESCENDING))
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.ALL_TIME)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.YES)
                .withIncludeDiscount(YesNoEnum.NO);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assumeThat("page отработал и вернулось ожидаемое количество строк (меньше либо равно, чем задано в ограничении)",
                (long) reportsData.getReportsLines().size(), lessThanOrEqualTo(pageLimit));

        previousLine = reportsData.getReportsLines().get(0);
        for (int i = 1; i < reportsData.getReportsLines().size(); i++) {
            currentLine = reportsData.getReportsLines().get(i);
            if (currentLine.getAdGroupId() > previousLine.getAdGroupId()) {
                isOrderCorrect = false;
            }
            if (! currentLine.getAge().equals(filterValue)){
                isOrderCorrect = false;
            }
            previousLine = currentLine;
        }
        assertThat("данные репорта вернулись в правильно отсортированном порядке", isOrderCorrect, equalTo(true));
    }
}
