package ru.yandex.autotests.directapi.reports.production;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
 * Smoke-тесты на проверку некоторых методов на production окружении.
 * Ходим под тестовым пользователем, у которого нет статистики. Просто проверяем, что сервис отвечает.
 */
@Aqua.Test
@Features(ApiFeatures.PRODUCTION)
@Issue("https://st.yandex-team.ru/DIRECT-66636")
@Stories(ReportsFeatures.ONLINE_CUSTOM_REPORT)
public class CreateNewReportProdTest {

    private final long CAMPAIGN_ID = 17236947;
    private static final String clientLogin = ReportsLogins.REPORTS_CLIENT;

    private static final String DATE_FROM = "2016-08-01";
    private static final String DATE_TO = "2016-08-27";

    private static final FieldEnum[] FIELD_NAMES = new FieldEnum[] {
            FieldEnum.CRITERIA_TYPE,
            FieldEnum.CRITERIA_ID,

            FieldEnum.DATE,
            FieldEnum.CLICKS,
            FieldEnum.CTR,
    };

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(clientLogin).clientLogin(clientLogin);

    @Test
    public void createNewReport() {
        ReportsData reports = api.userSteps.reportsSteps().callReportsXml(
                new ReportDefinitionMap()
                        .withDefaultReportWithTypeAndUniqueReportName(ReportTypeEnum.CUSTOM_REPORT)
                        .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                        .withSelectionCriteria(new SelectionCriteriaMap()
                                .withDateFrom(DATE_FROM)
                                .withDateTo(DATE_TO)
                                .withFilter(new FilterItemMap()
                                        .withField(FieldEnum.CAMPAIGN_ID)
                                        .withOperator(FilterOperatorEnum.EQUALS)
                                        .withValues(CAMPAIGN_ID)))
                        .withFieldNames(FIELD_NAMES)
                        .withPage(null),
                clientLogin);

        assertThat("Получен пустой отчёт", reports.getTotalRowsNumber(), equalTo(0L));
    }

}
