package ru.yandex.autotests.directapi.reports.reachreport;

import java.util.stream.Collectors;

import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.steps.statistics.ReportsSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 23.04.18.
 */
@Aqua.Test
@Description("REACH_AND_FREQUENCY_PERFORMANCE_REPORT возвращает те же данные, что и CUSTOM_REPORT")
@Issue("https://st.yandex-team.ru/DIRECT-79038")
@Features(ReportsFeatures.REACH_AND_FREQUENCY_PERFORMANCE_REPORT)
public class ReachAndFrequencyPerformanceReportCompareWithCustomReportTest {
    private static final Long[] CAMPAIGN_IDS = new Long[] { 35862387L };
    private static final String DATE_FROM = "2021-02-26";
    private static final String DATE_TO = "2021-02-27";

    private static final FieldEnum[] FIELD_NAMES = new FieldEnum[] {
            FieldEnum.CAMPAIGN_ID,
            FieldEnum.AGE,
            FieldEnum.GENDER,
            FieldEnum.DATE,
            FieldEnum.IMPRESSIONS,
            FieldEnum.CLICKS,
            FieldEnum.COST,
            FieldEnum.CTR,
    };

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.CLIENT_FOR_REACH_AND_FREQUENCY_PERFORMANCE_REPORT2);

    private static final ReportsSteps REPORTS_STEPS = api.userSteps.reportsSteps();

    @Test
    public void test() {
        ReportsData criteriaPerformanceReport = REPORTS_STEPS.callReportsXml(new ReportDefinitionMap()
                .withDefaultReportWithTypeAndUniqueReportName(ReportTypeEnum.REACH_AND_FREQUENCY_PERFORMANCE_REPORT)
                .withCustomDatesAndCampaignIds(DATE_FROM, DATE_TO, CAMPAIGN_IDS)
                .withFieldNames(FIELD_NAMES)
                .withPage(null));

        assumeThat("отчёт REACH_AND_FREQUENCY_PERFORMANCE_REPORT не пустой",
                criteriaPerformanceReport.getReportsLines(), not(empty()));

        ReportsData customReport = REPORTS_STEPS.callReportsXml(new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withCustomDatesAndCampaignIds(DATE_FROM, DATE_TO, CAMPAIGN_IDS)
                .withFieldNames(FIELD_NAMES)
                .withPage(null));

        assertThat("в отчётах одни и те же данные",
                criteriaPerformanceReport.getReportsLines(),
                containsInAnyOrder(customReport.getReportsLines().stream()
                        .map(BeanDifferMatcher::beanDiffer)
                        .collect(Collectors.toList())));
    }
}
