package ru.yandex.autotests.directapi.reports.searchquery;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.reports.CriteriaTypeEnum;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.PageMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsLine;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.everyItem;
import static org.hamcrest.Matchers.instanceOf;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by lightelfik on 26.04.19.
 */
@Aqua.Test
@Description("Проверка, что у автотаргетинга в Criteria и CriterionId возвращаются непустые значения в SearchQueryReport")
@Issue("https://st.yandex-team.ru/DIRECT-60974")
@Features(ReportsFeatures.SEARCH_QUERY_PERFORMANCE_REPORT)
public class CheckCriterionIdWithAutotargetigTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.CLIENT_WITH_AUTOTARGETING);

    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    @Test
    public void checkCriteriaForQueryReport() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.MONTH, -1);
        String date = DATE_FORMAT.format(calendar.getTime());
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withReportType(ReportTypeEnum.SEARCH_QUERY_PERFORMANCE_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withFieldNames(FieldEnum.CRITERIA, FieldEnum.CRITERIA_ID)
                .withPage(new PageMap().withLimit(10L))
                .withSelectionCriteria(
                        new SelectionCriteriaMap()
                                .withDateFrom(date)
                                .withDateTo(date)
                                .withFilter(
                                        new FilterItemMap()
                                                .withField(FieldEnum.CRITERIA_TYPE)
                                                .withOperator(FilterOperatorEnum.EQUALS)
                                                .withValues(CriteriaTypeEnum.AUTOTARGETING.value())
                                )
                );
        ReportsData report = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        List<Long> criteria_ids = report.getReportsLines().stream().map(ReportsLine::getCriteriaId)
                .collect(Collectors.toList());
        assumeThat("вернулся не пустой отчет", report.getReportsLines().size(), greaterThan(0));
        assertThat("в каждой из строчек вернулся CriteriaID", criteria_ids, everyItem(is(instanceOf(Long.class))));
    }
}
