package ru.yandex.autotests.directapi.reports.searchquery;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.*;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 09.11.16.
 * https://st.yandex-team.ru/TESTIRT-10416
 */
@Aqua.Test
@Description("Проверка на равенство значений из отчетов Custom и Search Query")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ReportsFeatures.SEARCH_QUERY_PERFORMANCE_REPORT)
public class CompareCustomVSSearchQueryReportsValuesTest {
    private final static DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final static Date DATE_FROM = getDateFrom();
    private final static Date DATE_TO = getDateTo();
    private final static int CAMPAIGN_ID = 5882736;
    private static int clicksCustomReport;
    private static int clicksSearchQueryReport;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.REPORT_CLIENT_FOR_COMPARE_REPORTS);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Date getDateFrom() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.MONTH, -1);
        return calendar.getTime();
    }

    private static Date getDateTo() {
        return Calendar.getInstance().getTime();
    }

    @BeforeClass
    public static void getClicksReport() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withFieldNames(FieldEnum.CLICKS)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withPage(new PageMap().withLimit(10000L))
                .withSelectionCriteria(
                        new SelectionCriteriaMap()
                                .withDateTo(DATE_FORMAT.format(DATE_TO))
                                .withDateFrom(DATE_FORMAT.format(DATE_FROM))
                                .withFilter(
                                        new FilterItemMap()
                                                .withField(FieldEnum.CAMPAIGN_ID)
                                                .withOperator(FilterOperatorEnum.EQUALS)
                                                .withValues(CAMPAIGN_ID))
                );
        ReportsData report = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assumeThat("вернулся не пустой отчет", report.getReportsLines(), hasSize(1));
        clicksCustomReport = report.getReportsLines().get(0).getClicks();
    }

    @BeforeClass
    public static void getClickSearchQueryReport() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultSearchQueryReportWithUniqueReportName()
                .withFieldNames(FieldEnum.CLICKS)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withPage(new PageMap().withLimit(10000L))
                .withSelectionCriteria(
                        new SelectionCriteriaMap()
                                .withFilter(
                                        new FilterItemMap()
                                                .withField(FieldEnum.CLICKS)
                                                .withOperator(FilterOperatorEnum.GREATER_THAN)
                                                .withValues(0),
                                        new FilterItemMap()
                                                .withField(FieldEnum.CAMPAIGN_ID)
                                                .withOperator(FilterOperatorEnum.EQUALS)
                                                .withValues(CAMPAIGN_ID))
                        .withDateFrom(DATE_FORMAT.format(DATE_FROM))
                        .withDateTo(DATE_FORMAT.format(DATE_TO))
                );
        ReportsData report = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assumeThat("вернулся непустой отчет", report.getReportsLines(), not(empty()));
        clicksSearchQueryReport = report.getReportsLines().stream().mapToInt(ReportsLine::getClicks).sum();
    }

    @Test
    public void checkClicksEqual() {
        assertThat("количество кликов из SearchQueryReport совпадает с количеством кликов из CustomReport", clicksSearchQueryReport, equalTo(clicksCustomReport));
    }
}
