package ru.yandex.autotests.directapi.reports.searchquery;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.common.api45.StatItem;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by onotole on 07.11.16.
 * https://st.yandex-team.ru/TESTIRT-10416
 */
@Aqua.Test
@Description("тесты на допустимые FieldNames, негативные случаи")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ReportsFeatures.SEARCH_QUERY_PERFORMANCE_REPORT)
@RunWith(Parameterized.class)
public class FieldNamesNegativeTest {
    // нельзя запрашивать статистику по данному срезу старше 90 дней,
    // поэтому чтобы постоянно не править тест вычисляем дату динамически
    private static final DateTime START_DATE = DateTime.now().minusDays(60);
    private static final DateTime END_DATE = DateTime.now().minusDays(30);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.CLIENT_FOR_NEGATIVE2);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public FieldEnum field;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][] {
                {FieldEnum.AD_NETWORK_TYPE},
                {FieldEnum.AGE},
                {FieldEnum.CARRIER_TYPE},
                {FieldEnum.CLICK_TYPE},
                {FieldEnum.DEVICE},
                {FieldEnum.DYNAMIC_TEXT_AD_TARGET_ID},
                {FieldEnum.EXTERNAL_NETWORK_NAME},
                {FieldEnum.GENDER},
                {FieldEnum.AD_FORMAT},
                {FieldEnum.IMPRESSION_SHARE},
                {FieldEnum.KEYWORD},
                {FieldEnum.LOCATION_OF_PRESENCE_ID},
                {FieldEnum.LOCATION_OF_PRESENCE_NAME},
                {FieldEnum.MOBILE_PLATFORM},
                {FieldEnum.RL_ADJUSTMENT_ID},
                {FieldEnum.SESSIONS},
                {FieldEnum.SLOT},
                {FieldEnum.TARGETING_LOCATION_ID},
                {FieldEnum.TARGETING_LOCATION_NAME}
        });
    }

    @Test
    public void getReportWithImpossibleField() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withReportType(ReportTypeEnum.SEARCH_QUERY_PERFORMANCE_REPORT)
                .withFieldNames(field)
                .withCustomDates(START_DATE, END_DATE);
        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap,
                new Api5Error(4000, Api5ErrorDetails.WRONG_VALUE_FOR_THIS_FIELD, "FieldNames",
                        field.value(), ReportTypeEnum.SEARCH_QUERY_PERFORMANCE_REPORT));
    }

}
