package ru.yandex.autotests.directapi.reports.searchquery;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 07.11.16.
 * https://st.yandex-team.ru/TESTIRT-10416
 */
@Aqua.Test
@Description("тесты на допустимые FieldNames")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ReportsFeatures.SEARCH_QUERY_PERFORMANCE_REPORT)
@RunWith(Parameterized.class)
public class FieldNamesPositiveTest {
    private static final String CLIENT = ReportsLogins.CLIENT_FOR_FIELD_POSITIVE;

    private static final String DATE_FROM;
    private static final String DATE_TO;

    static {
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

        Calendar dateFrom = Calendar.getInstance();
        dateFrom.add(Calendar.DATE, -80);
        DATE_FROM = dateFormat.format(dateFrom.getTime());

        Calendar dateTo = Calendar.getInstance();
        dateTo.add(Calendar.DATE, -79);
        DATE_TO = dateFormat.format(dateTo.getTime());
    }

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public FieldEnum field;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][] {
                {FieldEnum.AD_GROUP_ID},
                {FieldEnum.AD_GROUP_NAME},
                {FieldEnum.AD_ID},
                {FieldEnum.AVG_CPC},
                {FieldEnum.AVG_CLICK_POSITION},
                {FieldEnum.COST_PER_CONVERSION },
                {FieldEnum.AVG_IMPRESSION_POSITION},
                {FieldEnum.AVG_PAGEVIEWS },
                {FieldEnum.BOUNCE_RATE},
                {FieldEnum.BOUNCES},
                {FieldEnum.CAMPAIGN_ID},
                {FieldEnum.CAMPAIGN_NAME},
                {FieldEnum.CAMPAIGN_TYPE},
                {FieldEnum.CLICKS},
                {FieldEnum.CONVERSIONS},
                {FieldEnum.CONVERSION_RATE},
                {FieldEnum.COST},
                {FieldEnum.CRITERIA},
                {FieldEnum.CRITERIA_ID},
                {FieldEnum.CRITERIA_TYPE},
                {FieldEnum.CRITERION},
                {FieldEnum.CRITERION_ID},
                {FieldEnum.CRITERION_TYPE},
                {FieldEnum.CTR},
                {FieldEnum.DATE},
                {FieldEnum.GOALS_ROI},
                {FieldEnum.IMPRESSIONS},
                {FieldEnum.MATCH_TYPE},
                {FieldEnum.MATCHED_KEYWORD},
                {FieldEnum.MONTH},
                {FieldEnum.QUARTER},
                {FieldEnum.QUERY},
                {FieldEnum.PLACEMENT},
                {FieldEnum.REVENUE},
                {FieldEnum.WEEK},
                {FieldEnum.YEAR},
                {FieldEnum.TARGETING_CATEGORY},
                {FieldEnum.INCOME_GRADE}
        });
    }

    @Test
    public void getReportWithFieldName() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withReportType(ReportTypeEnum.SEARCH_QUERY_PERFORMANCE_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withFieldNames(field)
                .withSelectionCriteria(
                        new SelectionCriteriaMap()
                                .withDateFrom(DATE_FROM)
                                .withDateTo(DATE_TO));
        ReportsData report = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assertThat("отчет успешно вернулся", report.getReportHeader(), equalTo(
                String.format(ReportsData.REPORT_NAME_FORMAT, reportDefinitionMap.getReportName(), DATE_FROM, DATE_TO)));
    }

}
