package ru.yandex.autotests.directapi.reports.searchquery;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by onotole on 08.11.16.
 * https://st.yandex-team.ru/TESTIRT-10416
 */
@Aqua.Test
@Description("базовая проверка возможности фильтрации, негативные случаи")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ReportsFeatures.SEARCH_QUERY_PERFORMANCE_REPORT)
@RunWith(Parameterized.class)
public class FilterNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.CLIENT_FOR_NEGATIVE);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public FieldEnum filterField;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][]{
                {FieldEnum.AD_GROUP_NAME},
                {FieldEnum.AD_NETWORK_TYPE},
                {FieldEnum.AGE},
                {FieldEnum.BOUNCES},
                {FieldEnum.CAMPAIGN_NAME},
                {FieldEnum.CARRIER_TYPE},
                {FieldEnum.CLICK_TYPE},
                {FieldEnum.CRITERIA},
                {FieldEnum.CRITERIA_ID},
                {FieldEnum.CRITERION},
                {FieldEnum.CRITERION_ID},
                {FieldEnum.DATE},
                {FieldEnum.DEVICE},
                {FieldEnum.EXTERNAL_NETWORK_NAME},
                {FieldEnum.GENDER},
                {FieldEnum.AD_FORMAT},
                {FieldEnum.IMPRESSION_SHARE},
                {FieldEnum.LOCATION_OF_PRESENCE_ID},
                {FieldEnum.LOCATION_OF_PRESENCE_NAME},
                {FieldEnum.MOBILE_PLATFORM},
                {FieldEnum.QUARTER},
                {FieldEnum.RL_ADJUSTMENT_ID},
                {FieldEnum.SESSIONS},
                {FieldEnum.SLOT},
                {FieldEnum.TARGETING_LOCATION_ID},
                {FieldEnum.TARGETING_LOCATION_NAME},
                {FieldEnum.WEEK},
                {FieldEnum.YEAR}
        });
    }

    @Test
    public void getReportWithImpossibleFilterField() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultCustomReportWithUniqueReportName()
                .withReportType(ReportTypeEnum.SEARCH_QUERY_PERFORMANCE_REPORT)
                .withDateRangeType(DateRangeTypeEnum.TODAY)
                .withFieldNames(FieldEnum.QUERY, FieldEnum.AD_GROUP_ID)
                .withSelectionCriteria(
                        new SelectionCriteriaMap()
                                .withFilter(new FilterItemMap()
                                .withField(filterField)
                                .withOperator(FilterOperatorEnum.EQUALS)
                                .withValues("1"))
                );
        try {
            Thread.sleep(700);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap,
                new Api5Error(4001, Api5ErrorDetails.WRONG_VALUE_FOR_THIS_PARAMETER, "Filter.Field",
                        filterField.value(), ReportTypeEnum.SEARCH_QUERY_PERFORMANCE_REPORT));
    }

}
