package ru.yandex.autotests.directapi.reports.searchquery;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.FilterItemMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 08.11.16.
 * https://st.yandex-team.ru/TESTIRT-10416
 */
@Aqua.Test
@Description("базовая проверка возможности фильтрации")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ReportsFeatures.SEARCH_QUERY_PERFORMANCE_REPORT)
@RunWith(Parameterized.class)
public class FilterPositiveTest {
    private static final String DATE_FROM;
    private static final String DATE_TO;

    static {
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

        Calendar dateFrom = Calendar.getInstance();
        dateFrom.add(Calendar.DATE, -80);
        DATE_FROM = dateFormat.format(dateFrom.getTime());

        Calendar dateTo = Calendar.getInstance();
        dateTo.add(Calendar.DATE, -79);
        DATE_TO = dateFormat.format(dateTo.getTime());
    }

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.CLIENT_FOR_FILTER_POSITIVE);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public FieldEnum filterField;

    @Parameterized.Parameter(1)
    public FilterOperatorEnum operator;
    
    @Parameterized.Parameter(2)
    public String value;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][] {
                {FieldEnum.AD_GROUP_ID, FilterOperatorEnum.EQUALS, "1"},
                {FieldEnum.AD_ID, FilterOperatorEnum.EQUALS, "1"},
                {FieldEnum.AVG_CPC, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.AVG_CLICK_POSITION, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.COST_PER_CONVERSION, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.AVG_IMPRESSION_POSITION, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.AVG_PAGEVIEWS, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.BOUNCE_RATE, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.CAMPAIGN_ID, FilterOperatorEnum.EQUALS, "1"},
                {FieldEnum.CLICKS, FilterOperatorEnum.EQUALS, "1"},
                {FieldEnum.CONVERSIONS, FilterOperatorEnum.EQUALS, "1"},
                {FieldEnum.CONVERSION_RATE, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.COST, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.CTR, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.DYNAMIC_TEXT_AD_TARGET_ID, FilterOperatorEnum.EQUALS, "1"},
                {FieldEnum.GOALS_ROI, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.IMPRESSIONS, FilterOperatorEnum.EQUALS, "1"},
                {FieldEnum.KEYWORD, FilterOperatorEnum.EQUALS, "1"},
                {FieldEnum.MATCHED_KEYWORD, FilterOperatorEnum.EQUALS, "1"},
                {FieldEnum.QUERY, FilterOperatorEnum.EQUALS, "1"},
                {FieldEnum.PLACEMENT, FilterOperatorEnum.EQUALS, "1"},
                {FieldEnum.REVENUE, FilterOperatorEnum.GREATER_THAN, "1"},
                {FieldEnum.TARGETING_CATEGORY, FilterOperatorEnum.EQUALS, "EXACT"},
                {FieldEnum.INCOME_GRADE, FilterOperatorEnum.EQUALS, "ABOVE_AVERAGE"},
        });
    }

    @Test
    public void filterReportByField() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultSearchQueryReportWithUniqueReportName()
                .withFieldNames(FieldEnum.QUERY, FieldEnum.AD_GROUP_ID)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withSelectionCriteria(
                        new SelectionCriteriaMap()
                                .withDateFrom(DATE_FROM)
                                .withDateTo(DATE_TO)
                                .withFilter(new FilterItemMap()
                                .withField(filterField)
                                .withOperator(operator)
                                .withValues(value))

                );
        ReportsData report = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);

        assertThat("отчет успешно вернулся", report.getReportHeader(), equalTo(
                String.format(ReportsData.REPORT_NAME_FORMAT, reportDefinitionMap.getReportName(), DATE_FROM, DATE_TO)));


    }

}
