package ru.yandex.autotests.directapi.reports.searchquery;

import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.OrderByMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.reports.ReportsFeatures;
import ru.yandex.autotests.directapi.reports.ReportsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by onotole on 08.11.16.
 * https://st.yandex-team.ru/TESTIRT-10416
 */
@Aqua.Test
@Description("базовые тесты на сортировку, негативные случаи")
@Issue("https://st.yandex-team.ru/TESTIRT-9244")
@Features(ReportsFeatures.SEARCH_QUERY_PERFORMANCE_REPORT)
@RunWith(Parameterized.class)
public class OrderByNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER).clientLogin(ReportsLogins.CLIENT_FOR_NEGATIVE3);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public FieldEnum orderByField;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][] {
                {FieldEnum.AD_NETWORK_TYPE},
                {FieldEnum.AGE},
                {FieldEnum.CARRIER_TYPE},
                {FieldEnum.CLICK_TYPE},
                {FieldEnum.CRITERIA},
                {FieldEnum.CRITERIA_ID},
                {FieldEnum.CRITERION},
                {FieldEnum.CRITERION_ID},
                {FieldEnum.DEVICE},
                {FieldEnum.DYNAMIC_TEXT_AD_TARGET_ID},
                {FieldEnum.EXTERNAL_NETWORK_NAME},
                {FieldEnum.GENDER},
                {FieldEnum.AD_FORMAT},
                {FieldEnum.IMPRESSION_SHARE},
                {FieldEnum.KEYWORD},
                {FieldEnum.LOCATION_OF_PRESENCE_ID},
                {FieldEnum.LOCATION_OF_PRESENCE_NAME},
                {FieldEnum.MOBILE_PLATFORM},
                {FieldEnum.RL_ADJUSTMENT_ID},
                {FieldEnum.SESSIONS},
                {FieldEnum.SLOT},
                {FieldEnum.TARGETING_LOCATION_ID},
                {FieldEnum.TARGETING_LOCATION_NAME}
        });
    }

    @Test
    public void orderByImpossibleFieldReport() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withDefaultSearchQueryReportWithUniqueReportName()
                .withFieldNames(FieldEnum.QUERY)
                .withDateRangeType(DateRangeTypeEnum.TODAY)
                .withOrderBy(new OrderByMap()
                        .withField(orderByField))
                .withSelectionCriteria(
                        new SelectionCriteriaMap()
                );
        try {
            Thread.sleep(700);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        api.userSteps.reportsSteps().expectXmlErrorOnReports(reportDefinitionMap,
                new Api5Error(4000, Api5ErrorDetails.WRONG_VALUES_FOR_THIS_PARAMETER, "OrderBy.Field",
                        orderByField.value(), ReportTypeEnum.SEARCH_QUERY_PERFORMANCE_REPORT));


    }
}
