package ru.yandex.autotests.directapi.retargetinglists.add;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.UsersStatusblocked;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;

/**
 * Created by onotole on 22.12.16.
 * https://st.yandex-team.ru/TESTIRT-10815
 */

@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Проверка недоступности изменяющих данные пользователя методов API представителям агенства если пользователь заблокирован")
@Issue("https://st.yandex-team.ru/DIRECT-60650")
@RunWith(Parameterized.class)
public class AddRetargetingListsBlockedByAgencyTest {
    private static final String CLIENT = RetargetingListsLogins.BLOCK_API_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String operator;

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList((Object[][]) new Object[][]{
                {RetargetingListsLogins.BLOCK_API_AGENCY},
                {RetargetingListsLogins.BLOCK_API_REP},
                {RetargetingListsLogins.BLOCK_API_MINOR_REP},
        });
    }

    @BeforeClass
    public static void setUp() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        long clientUid = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(CLIENT).getPassportID());
        api.userSteps.getDirectJooqDbSteps().useShard(shard).usersSteps().setBlocked(clientUid, UsersStatusblocked.Yes);
    }

    @Test
    public void addForBlockedUser() {
        api.as(operator).userSteps.retargetingListsSteps().expectErrorOnAdd(
                CLIENT,
                new AddRequestMap()
                        .withRetargetingLists(new RetargetingListAddItemMap()
                                .withRandomName()
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                        .withArgumentItems(
                                                new RetargetingListRuleArgumentItemMap().withExternalId(1)))),
                new Api5Error(3000, Api5ErrorDetailsJava.ACCOUNT_BLOCKED)
                        .withMessageFromResource(Api5ErrorMessage.NO_ACCESS_TO_API_JAVA)
        );
    }

    @Test
    public void getWorkedForBlockedUser() {
        List<Long> goals = api.as(operator).userSteps.retargetingSteps()
                .getRetargetingGoalIDsByType(CLIENT, RetargetingGoalType.GOAL);
        assertThat("запрос get успешно отработал", goals, not(empty()));
    }

}
