package ru.yandex.autotests.directapi.retargetinglists.add;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.UsersStatusblocked;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by onotole on 22.12.16.
 * https://st.yandex-team.ru/TESTIRT-10815
 */

@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Проверка недоступности методов API пользователю если он заблокирован")
@Issue("https://st.yandex-team.ru/DIRECT-60650")
public class AddRetargetingListsBlockedClientTest {
    private static final String CLIENT = RetargetingListsLogins.BLOCK_API_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void setUp() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        long clientUid = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(CLIENT).getPassportID());
        api.userSteps.getDirectJooqDbSteps().useShard(shard).usersSteps().setBlocked(clientUid, UsersStatusblocked.Yes);
    }

    @Test
    public void addForBlockedUser() {
        api.userSteps.retargetingListsSteps().expectErrorOnAdd(
                CLIENT,
                new AddRequestMap()
                        .withRetargetingLists(new RetargetingListAddItemMap()
                                .withRandomName()
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                        .withArgumentItems(
                                                new RetargetingListRuleArgumentItemMap().withExternalId(1)))),
                new Api5Error(3000, Api5ErrorDetailsJava.ACCOUNT_BLOCKED)
                        .withMessageFromResource(Api5ErrorMessage.NO_ACCESS_TO_API_JAVA)
        );
    }

    @Test
    public void getDontWorkForBlockedUser() {
        api.userSteps.retargetingListsSteps().expectErrorOnGet(new GetRequestMap(),
                new Api5Error(3000, Api5ErrorDetailsJava.ACCOUNT_BLOCKED)
                        .withMessageFromResource(Api5ErrorMessage.NO_ACCESS_TO_API_JAVA));
    }

}
