package ru.yandex.autotests.directapi.retargetinglists.add;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by buhter on 24/02/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Проверка валидации поля Description")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class AddRetargetingListsDescriptionTest {
    private static long correctGoalId;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING42;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public ExpectedResult result;


    @Parameterized.Parameters(name = "Description - {0}")
    public static Collection data() {
        Object[][] data = new Object[][]{
                {"", ExpectedResult.success()},
                {null, ExpectedResult.success()},
                {" ", ExpectedResult.success()},
                {".", ExpectedResult.success()},
                {RandomStringUtils.random(5, RandomUtils.LATIN_CHARS), ExpectedResult.success()},
                {RandomStringUtils.random(5, RandomUtils.TURKEY_CHARS), ExpectedResult.success()},
                {RandomStringUtils.random(5, RandomUtils.KAZAKH_CHARS), ExpectedResult.success()},
                {RandomStringUtils.random(5, RandomUtils.UKRAIN_CHARS), ExpectedResult.success()},
                {RandomStringUtils.random(5, RandomUtils.CYRILYC_CHARS), ExpectedResult.success()},
                {RandomStringUtils.randomAlphabetic(RetargetingListAddItemMap.MAX_LENGTH_OF_DESCRIPTION),
                        ExpectedResult.success()},
                {RandomStringUtils.randomAlphabetic(RetargetingListAddItemMap.MAX_LENGTH_OF_DESCRIPTION + 1),
                        ExpectedResult.errors(
                        new Notification(5001,
                                Api5ErrorDetailsJava.MAX_STR_LENGTH,
                                path(RetargetingListAddItemMap.DESCRIPTION),
                                RetargetingListAddItemMap.MAX_LENGTH_OF_DESCRIPTION))},
                {"#$%^&*()", ExpectedResult.errors(
                        new Notification(5002,
                                Api5ErrorDetailsJava.INVALID_CHARS,
                                path(RetargetingListAddItemMap.DESCRIPTION)))},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        correctGoalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
    }

    @Test
    public void testAddDescription() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(correctGoalId)
                                        .withDescription(description)),
                result
        );
    }
}

