package ru.yandex.autotests.directapi.retargetinglists.add;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Валидация JSON-запроса при добавлении")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class AddRetargetingListsJsonValidationTest {
    private static long CORRECT_GOAL_ID;
    private static String INVALID_FIELD = "invalidField";
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING42;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        CORRECT_GOAL_ID = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
    }

    @Test
    public void notArrayRetargetingLists(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), CORRECT_GOAL_ID);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListAddItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListAddItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListAddItemMap.DESCRIPTION), "Description");
        request.put(capitalize(AddRequestMap.RETARGETING_LISTS), retargetingLists);
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(AddRequestMap.RETARGETING_LISTS)));
    }

    @Test
    public void invalidFieldInRetargetingLists(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), CORRECT_GOAL_ID);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListAddItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListAddItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListAddItemMap.DESCRIPTION), "Description");
        retargetingLists.put(INVALID_FIELD, INVALID_FIELD);
        request.put(capitalize(AddRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
                        path(AddRequestMap.RETARGETING_LISTS), INVALID_FIELD));
    }

    @Test
    public void arrayInName(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), CORRECT_GOAL_ID);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListAddItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListAddItemMap.NAME), new Object[]{"Name"});
        retargetingLists.put(capitalize(RetargetingListAddItemMap.DESCRIPTION), "Description");
        request.put(capitalize(AddRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(AddRequestMap.RETARGETING_LISTS, RetargetingListAddItemMap.NAME)));
    }

    @Test
    public void arrayInDescription(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), CORRECT_GOAL_ID);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListAddItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListAddItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListAddItemMap.DESCRIPTION), new Object[]{"Description"});
        request.put(capitalize(AddRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(AddRequestMap.RETARGETING_LISTS, RetargetingListAddItemMap.DESCRIPTION)));
    }

    @Test
    public void notArrayInRules(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), CORRECT_GOAL_ID);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListAddItemMap.RULES), rules);
        retargetingLists.put(capitalize(RetargetingListAddItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListAddItemMap.DESCRIPTION), "Description");
        request.put(capitalize(AddRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(AddRequestMap.RETARGETING_LISTS, RetargetingListAddItemMap.RULES)));
    }

    @Test
    public void invalidFieldInRules(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), CORRECT_GOAL_ID);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        rules.put(INVALID_FIELD, INVALID_FIELD);
        retargetingLists.put(capitalize(RetargetingListAddItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListAddItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListAddItemMap.DESCRIPTION), "Description");
        request.put(capitalize(AddRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
                        path(AddRequestMap.RETARGETING_LISTS, RetargetingListAddItemMap.RULES),
                                INVALID_FIELD));
    }

    @Test
    public void arrayInOperatorField(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), CORRECT_GOAL_ID);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), new Object[]{RetargetingListRuleOperatorEnum.ANY});
        retargetingLists.put(capitalize(RetargetingListAddItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListAddItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListAddItemMap.DESCRIPTION), "Description");
        request.put(capitalize(AddRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(AddRequestMap.RETARGETING_LISTS,
                                RetargetingListAddItemMap.RULES,
                                RetargetingListRuleItemMap.OPERATOR)));
    }

    @Test
    public void notArrayInArgumentsField(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), CORRECT_GOAL_ID);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), arguments);
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListAddItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListAddItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListAddItemMap.DESCRIPTION), "Description");
        request.put(capitalize(AddRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(AddRequestMap.RETARGETING_LISTS,
                                RetargetingListAddItemMap.RULES,
                                RetargetingListRuleItemMap.ARGUMENTS)));
    }

    @Test
    public void invalidFieldInArgumentsField(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), CORRECT_GOAL_ID);
        arguments.put(INVALID_FIELD, INVALID_FIELD);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListAddItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListAddItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListAddItemMap.DESCRIPTION), "Description");
        request.put(capitalize(AddRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
                        path(AddRequestMap.RETARGETING_LISTS,
                                RetargetingListAddItemMap.RULES,
                                RetargetingListRuleItemMap.ARGUMENTS),
                        INVALID_FIELD));
    }

    @Test
    public void arrayInLifespanField(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), new Object[]{30});
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), CORRECT_GOAL_ID);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListAddItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListAddItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListAddItemMap.DESCRIPTION), "Description");
        request.put(capitalize(AddRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(AddRequestMap.RETARGETING_LISTS,
                                RetargetingListAddItemMap.RULES,
                                RetargetingListRuleItemMap.ARGUMENTS,
                                RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN)));
    }

    @Test
    public void arrayInExternalIdField(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), new Object[]{CORRECT_GOAL_ID});
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListAddItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListAddItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListAddItemMap.DESCRIPTION), "Description");
        request.put(capitalize(AddRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(AddRequestMap.RETARGETING_LISTS,
                                RetargetingListAddItemMap.RULES,
                                RetargetingListRuleItemMap.ARGUMENTS,
                                RetargetingListRuleArgumentItemMap.EXTERNAL_ID)));
    }

}
