package ru.yandex.autotests.directapi.retargetinglists.add;

import java.util.Arrays;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Проверка лимитов метода Add")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class AddRetargetingListsLimitTest {
    private static long correctGoalId1;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING39;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        correctGoalId1 = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
    }

    @Test
    public void moreThanMaxRetargetingListsInOneRequest() {
        RetargetingListAddItemMap[] retargetingLists =
                new RetargetingListAddItemMap[AddRequestMap.MAX_AMOUNT_RETARGETING_LISTS_IN_ONE_REQUEST + 1];
        Arrays.fill(retargetingLists,
                new RetargetingListAddItemMap()
                        .defaultRetargetingListAddItemMap(correctGoalId1));
        api.userSteps.retargetingListsSteps().expectErrorOnAdd(new AddRequestMap()
                        .withRetargetingLists(retargetingLists),
                new Api5Error(9300,
                        Api5ErrorDetailsJava.MAX_OBJECTS,
                        AddRequestMap.MAX_AMOUNT_RETARGETING_LISTS_IN_ONE_REQUEST));
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }


    @Test
    public void maxRetargetingListsInOneRequest() {
        RetargetingListAddItemMap[] retargetingLists =
                new RetargetingListAddItemMap[AddRequestMap.MAX_AMOUNT_RETARGETING_LISTS_IN_ONE_REQUEST];
        Arrays.fill(retargetingLists,
                new RetargetingListAddItemMap()
                        .defaultRetargetingListAddItemMap(correctGoalId1));
        ExpectedResult[] results =
                new ExpectedResult[retargetingLists.length];

        Arrays.fill(results, ExpectedResult.errors(
                new Notification(9800,
                        Api5ErrorDetailsJava.DUPLICATED_OBJECT_NAME),
                new Notification(9800,
                        Api5ErrorDetailsJava.DUPLICATED_OBJECT_RULES)));

        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withRetargetingLists(retargetingLists),
                results
        );
    }

    @Test
    public void maxRules() {
        RetargetingListRuleItemMap[] rules =
                new RetargetingListRuleItemMap[RetargetingListAddItemMap.MAX_AMOUNT_OF_RULES];
        Arrays.fill(rules,
                new RetargetingListRuleItemMap()
                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                .withMembershipLifeSpan(1)
                                .withExternalId(correctGoalId1)));
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRandomDescription()
                                        .withRules(rules)
                        ),
                ExpectedResult.success());
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void moreThanMaxRules() {
        //DIRECT-58102
        RetargetingListRuleItemMap[] rules =
                new RetargetingListRuleItemMap[RetargetingListAddItemMap.MAX_AMOUNT_OF_RULES + 1];
        Arrays.fill(rules,
                new RetargetingListRuleItemMap()
                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                .withMembershipLifeSpan(1)
                                .withExternalId(correctGoalId1)));
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRandomDescription()
                                        .withRules(rules)
                        ),
                ExpectedResult.errors(
                        new Notification(7000, Api5ErrorDetailsJava.INVALID_LIST_SIZE,
                                path(RetargetingListAddItemMap.RULES),
                                1,
                                RetargetingListAddItemMap.MAX_AMOUNT_OF_RULES)));
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

    }

    @Test
    public void maxArguments() {
        RetargetingListRuleArgumentItemMap[] arguments =
                new RetargetingListRuleArgumentItemMap[RetargetingListRuleItemMap.MAX_AMOUNT_OF_ARGUMENTS];
        Arrays.fill(arguments,
                new RetargetingListRuleArgumentItemMap()
                        .withMembershipLifeSpan(1)
                        .withExternalId(correctGoalId1));
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRandomDescription()
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                        .withArgumentItems(arguments)
                                        )
                        ),
                ExpectedResult.success());
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void moreThanMaxArgument() {
        //DIRECT-58101
        RetargetingListRuleArgumentItemMap[] arguments =
                new RetargetingListRuleArgumentItemMap[RetargetingListRuleItemMap.MAX_AMOUNT_OF_ARGUMENTS + 1];
        Arrays.fill(arguments,
                new RetargetingListRuleArgumentItemMap()
                        .withMembershipLifeSpan(1)
                        .withExternalId(correctGoalId1));
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRandomDescription()
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                        .withArgumentItems(arguments)
                                        )
                        ),
                ExpectedResult.errors(
                        new Notification(7000, Api5ErrorDetailsJava.INVALID_LIST_SIZE,
                                path(RetargetingListAddItemMap.RULES, 0, RetargetingListRuleItemMap.ARGUMENTS),
                                1,
                                RetargetingListRuleItemMap.MAX_AMOUNT_OF_ARGUMENTS)));
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

}
