package ru.yandex.autotests.directapi.retargetinglists.add;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by buhter on 24/02/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Проверка валидации поля Name")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class AddRetargetingListsNameValidationTest {
    private static long correctGoalId;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING5;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String name;

    @Parameterized.Parameter(1)
    public ExpectedResult result;

    @Parameterized.Parameters(name = "Name - {0}")
    public static Collection data() {
        Object[][] data = new Object[][]{
                {"", ExpectedResult.errors(
                        new Notification(5003, Api5ErrorDetailsJava.EMPTY_VALUE
                                , path(RetargetingListAddItemMap.NAME)))},
                {RandomStringUtils.random(5, RandomUtils.LATIN_CHARS), ExpectedResult.success()},
                {RandomStringUtils.random(5, RandomUtils.TURKEY_CHARS), ExpectedResult.success()},
                {RandomStringUtils.random(5, RandomUtils.KAZAKH_CHARS), ExpectedResult.success()},
                {RandomStringUtils.random(5, RandomUtils.UKRAIN_CHARS), ExpectedResult.success()},
                {RandomStringUtils.random(5, RandomUtils.CYRILYC_CHARS), ExpectedResult.success()},
                {" ", ExpectedResult.errors(
                        new Notification(5003, Api5ErrorDetailsJava.EMPTY_VALUE
                                , path(RetargetingListAddItemMap.NAME)))},
                {"  ", ExpectedResult.errors(
                        new Notification(5003, Api5ErrorDetailsJava.EMPTY_VALUE
                                , path(RetargetingListAddItemMap.NAME)))},
                {".", ExpectedResult.success()},
                {RandomStringUtils.randomAlphabetic(RetargetingListAddItemMap.MAX_LENGTH_OF_NAME), ExpectedResult.success()},
                {RandomStringUtils.randomAlphabetic(RetargetingListAddItemMap.MAX_LENGTH_OF_NAME + 1),
                        ExpectedResult.errors(
                                new Notification(5001,
                                        Api5ErrorDetailsJava.MAX_STR_LENGTH,
                                        path(RetargetingListAddItemMap.NAME),
                                        RetargetingListAddItemMap.MAX_LENGTH_OF_NAME))},
                {"#$%^&*()", ExpectedResult.errors(
                        new Notification(5002,
                                Api5ErrorDetailsJava.INVALID_CHARS,
                                capitalize(RetargetingListAddItemMap.NAME)))},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        correctGoalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
    }

    @Test
    public void testAddWithName() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(correctGoalId)
                                        .withName(name))
                , result);
    }
}

