package ru.yandex.autotests.directapi.retargetinglists.add;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 24/02/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Проверка верного добавления условия подбора аудитории с различными операторами")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class AddRetargetingListsOperatorValidationTest {
    private static long goalId1;
    private static long goalId2;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING40;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        List<Long> goalIds = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL);
        assumeThat("у клиента должно быть > 1 цели", goalIds.size(), greaterThan(1));
        goalId1 = goalIds.get(0);
        goalId2 = goalIds.get(1);
    }

    @Test
    public void testAny() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goalId1))))
                , ExpectedResult.success());
    }

    @Test
    public void testAll() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goalId1))))
                , ExpectedResult.success());
    }

    @Test
    public void testNone() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goalId1))))
                , ExpectedResult.success());
    }

    @Test
    public void testAnyAndAll() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRules(new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withRandomMembershipLifeSpan()
                                                                .withExternalId(goalId1))
                                                , new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withRandomMembershipLifeSpan()
                                                                .withExternalId(goalId2))))
                , ExpectedResult.success());
    }

    @Test
    public void testNoneAndAll() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRules(new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withRandomMembershipLifeSpan()
                                                                .withExternalId(goalId1))
                                                , new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withRandomMembershipLifeSpan()
                                                                .withExternalId(goalId2))))
                , ExpectedResult.success());
    }

    @Test
    public void testAnyAndNone() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRules(new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withRandomMembershipLifeSpan()
                                                                .withExternalId(goalId1))
                                                , new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withRandomMembershipLifeSpan()
                                                                .withExternalId(goalId2))))
                , ExpectedResult.success());
    }

}

