package ru.yandex.autotests.directapi.retargetinglists.add;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Проверка корректности работы метода для разных ролей")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class AddRetargetingListsRoleNegativeTest {
    private static final String MANAGER = Logins.MANAGER_DEFAULT;
    private static final String SUPER_READER = Logins.SUPER_READER;
    private static final String CLIENT = RetargetingListsLogins.ADD_CLIENT;
    private static final String SUBCLIENT1 = RetargetingListsLogins.ADD_SUBCLIENT1;
    private static final String AGENCY_REP = RetargetingListsLogins.ADD_AGENCY_REP;
    private static final String MEDIA = Logins.MEDIA;
    private static final int CORRECT_LIFESPAN = 10;
    private Long goalId;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String apiUserLogin;

    @Parameterized.Parameter(2)
    public String login;

    @Parameterized.Parameter(3)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {

        return Arrays.asList(new Object[][]{
                {"Добавление условий от имени медиапланера", MEDIA, CLIENT, new Api5Error(54)},
                {"Добавление условий от имени суперридера", SUPER_READER, CLIENT, new Api5Error(54)},
                {"Добавление условий от имени субклиента для самого себя", SUBCLIENT1, SUBCLIENT1, new Api5Error(54)},
                {"Добавление условий от имени менеджера для клиента", MANAGER, CLIENT,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                {"Добавление условий от имени представителя агентства для субклиента на которого нет прав",
                        AGENCY_REP, SUBCLIENT1, new Api5Error(54)},
        });
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SUBCLIENT1);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        goalId = api.as(login).userSteps.retargetingSteps().getRetargetingGoalIDsByType(login, RetargetingGoalType.GOAL)
                .get(0);
    }

    @Test
    public void addUsingLogin() {
        api.as(apiUserLogin);
        api.userSteps.retargetingListsSteps().expectErrorOnAdd(
                login,
                new AddRequestMap()
                        .withRetargetingLists(new RetargetingListAddItemMap()
                                .withRandomName()
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withMembershipLifeSpan(CORRECT_LIFESPAN)
                                                .withExternalId(goalId)))),
                expectedError);
    }
}

