package ru.yandex.autotests.directapi.retargetinglists.add;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Проверка корректности работы метода для разных ролей")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class AddRetargetingListsRoleTest {
    private static final String MANAGER = Logins.MANAGER_DEFAULT;
    private static final String SUPER = Logins.SUPER_LOGIN;
    private static final String PLACER = Logins.PLACER;
    private static final String SUPPORT = Logins.SUPPORT;
    private static final String SERV_CLIENT = RetargetingListsLogins.ADD_SERV_CLIENT;
    private static final String CLIENT = RetargetingListsLogins.ADD_CLIENT;
    private static final String CLIENT_REP = RetargetingListsLogins.ADD_CLIENT_REP;
    private static final String AGENCY = RetargetingListsLogins.ADD_AGENCY;
    private static final String AGENCY_REP = RetargetingListsLogins.ADD_AGENCY_REP;
    private static final String SUBCLIENT1 = RetargetingListsLogins.ADD_SUBCLIENT1;
    private static final String SUBCLIENT2 = RetargetingListsLogins.ADD_SUBCLIENT2;
    private static final String SUBCLIENT3 = RetargetingListsLogins.ADD_SUBCLIENT3;

    private static final int CORRECT_LIFESPAN = 10;

    private static final Api5Error noRights = new Api5Error(54);

    private Long goalId;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String apiUserLogin;

    @Parameterized.Parameter(2)
    public String login;

    @Parameterized.Parameter(3)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {

        return Arrays.asList(new Object[][]{
                {"Добавление условий от имени менеджера", MANAGER, SERV_CLIENT, null},

                {"Добавление условий от имени вешальщика", PLACER, CLIENT, noRights},

                {"Добавление условий от имени саппорта", SUPPORT, CLIENT, null},

                {"Добавление условий от имени супера", SUPER, CLIENT, null},

                {"Добавление условий от имени клиента для самого себя", CLIENT, CLIENT, null},

                {"Добавление условий от имени представителя клиента для клиента", CLIENT_REP, CLIENT, null},

                {"Добавление условий от имени агенства для субклиента", AGENCY, SUBCLIENT1, null},

                {"Добавление условий от имени агенства для второго субклиента", AGENCY, SUBCLIENT2, null},

                {"Добавление условий от имени менеджера для субклиента своего агентства", MANAGER, SUBCLIENT1, null},

                {"Добавление условий от имени представителя агенства для субклиента", AGENCY_REP, SUBCLIENT2, null},

                {"Добавление условий от субклиента с правом редактировать для самого себя", SUBCLIENT3, SUBCLIENT3, null},
        });
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT_REP);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY_REP);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SUBCLIENT1);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SUBCLIENT2);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SUBCLIENT3);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SERV_CLIENT);
        goalId = api.as(login).userSteps.retargetingSteps().getRetargetingGoalIDsByType(login, RetargetingGoalType.GOAL).get(0);
    }

    @Test
    public void addUsingLogin() {
        api.as(apiUserLogin);
        api.userSteps.retargetingListsSteps().expectErrorOnAdd(
                login,
                new AddRequestMap()
                        .withRetargetingLists(new RetargetingListAddItemMap()
                                .withRandomName()
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withMembershipLifeSpan(CORRECT_LIFESPAN)
                                                .withExternalId(goalId)))),
                expectedError
        );
    }
}


