package ru.yandex.autotests.directapi.retargetinglists.add;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by pavryabov on 06.09.16.
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Проверка работы метода при добавлении одинаковых объектов/полей в одном запросе")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class AddRetargetingListsSameItemsInOneRequestTest {
    //DIRECT-58130

    private static long correctGoalId;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING38;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        List<Long> goalIds = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL);
        assumeThat("получено больше 1 объекта", goalIds.size(), greaterThan(1));
        correctGoalId = goalIds.get(0);
    }

    @Test
    public void testAddWithSameName() {
        String name = "Name1" + RandomStringUtils.randomAlphabetic(6);
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withDescription("Description1" + RandomStringUtils.randomAlphabetic(6))
                                        .withName(name)
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(correctGoalId))),
                                new RetargetingListAddItemMap()
                                        .withDescription("Another Description1" + RandomStringUtils.randomAlphabetic(6))
                                        .withName(name)
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(correctGoalId)))),
                ExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT_NAME)),
                ExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT_NAME)));
    }

    @Test
    public void testAddWithSameDescription() {
        String description = "Description1" + RandomStringUtils.randomAlphabetic(6);
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withDescription(description)
                                        .withName("Name1" + RandomStringUtils.randomAlphabetic(6))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(correctGoalId))),
                                new RetargetingListAddItemMap()
                                        .withDescription(description)
                                        .withName("Another Name1" + RandomStringUtils.randomAlphabetic(6))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(correctGoalId)))),
                ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    public void testAddWithSameRules() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withDescription("Description1" + RandomStringUtils.randomAlphabetic(6))
                                        .withName("Name1" + RandomStringUtils.randomAlphabetic(6))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withDefaultMembershipLifeSpan()
                                                        .withExternalId(correctGoalId))),
                                new RetargetingListAddItemMap()
                                        .withDescription("Another Description1" + RandomStringUtils.randomAlphabetic(6))
                                        .withName("Another Name1" + RandomStringUtils.randomAlphabetic(6))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withDefaultMembershipLifeSpan()
                                                        .withExternalId(correctGoalId)))),
                ExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT_RULES)),
                ExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT_RULES)));
    }

    @Test
    public void testAddWithSameAddItems() {
        String name = "Name1" + RandomStringUtils.randomAlphabetic(6);
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withDescription("Description1" + RandomStringUtils.randomAlphabetic(6))
                                        .withName(name)
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withDefaultMembershipLifeSpan()
                                                        .withExternalId(correctGoalId))),
                                new RetargetingListAddItemMap()
                                        .withDescription("Another Description1" + RandomStringUtils.randomAlphabetic(6))
                                        .withName(name)
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withDefaultMembershipLifeSpan()
                                                        .withExternalId(correctGoalId)))),
                ExpectedResult.errors(
                        new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT_NAME),
                        new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT_RULES)),
                ExpectedResult.errors(
                        new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT_NAME),
                        new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT_RULES))
                );
    }
}