package ru.yandex.autotests.directapi.retargetinglists.add;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by buhter on 24/02/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Проверка работы метода при добавлении одинаковых объектов/полей")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class AddRetargetingListsSameItemsTest {
    private static long correctGoalId;
    private static long anotherCorrectGoalId;
    private static final RetargetingListRuleOperatorEnum OPERATOR_ENUM = RetargetingListRuleOperatorEnum.ANY;
    private static final RetargetingListRuleOperatorEnum ANOTHER_OPERATOR_ENUM = RetargetingListRuleOperatorEnum.ALL;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING39;
    private static final String ANOTHER_LOGIN = RetargetingListsLogins.LOGIN_RETARGETING38;
    private String name;
    private String anotherName;
    private String description;
    private String anotherDescription;
    private static Long anotherLoginGoalId;
    private Long id;
    private Long idAfterUpdate;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        List<Long> goalIds = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL);
        assumeThat("получено больше 1 объекта", goalIds.size(), greaterThan(1));
        correctGoalId = goalIds.get(0);
        anotherCorrectGoalId = goalIds.get(1);
        anotherLoginGoalId = api.as(ANOTHER_LOGIN).userSteps.retargetingSteps().getRetargetingGoalIDsByType(ANOTHER_LOGIN, RetargetingGoalType.GOAL).get(0);
    }

    @Before
    public void init() {
        api.as(LOGIN);
        name = "Name" + RandomStringUtils.randomAlphabetic(6);
        anotherName = "Another Name" + RandomStringUtils.randomAlphabetic(6);
        description = "Description" + RandomStringUtils.randomAlphabetic(6);
        anotherDescription = "Another Description" + RandomStringUtils.randomAlphabetic(6);
        id = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withDescription(description)
                                        .withName(name)
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(OPERATOR_ENUM)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withDefaultMembershipLifeSpan()
                                                        .withExternalId(correctGoalId))))
                , ExpectedResult.success()).getAddResults().get(0).getId();
        idAfterUpdate = null;

    }

    @Test
    public void testAddWithSameName() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withDescription(anotherDescription)
                                        .withName(name)
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(ANOTHER_OPERATOR_ENUM)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withDefaultMembershipLifeSpan()
                                                        .withExternalId(anotherCorrectGoalId))))
                , ExpectedResult.errors(new Notification(6000, Api5ErrorDetailsJava.OBJECT_EXISTS,
                        path(RetargetingListAddItemMap.NAME))));
    }

    @Test
    public void testAddWithSameDataAnotherClient() {
        idAfterUpdate = api.as(ANOTHER_LOGIN).userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withDescription(description)
                                        .withName(name)
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(OPERATOR_ENUM)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withDefaultMembershipLifeSpan()
                                                        .withExternalId(anotherLoginGoalId))))
                , ExpectedResult.success()).getAddResults().get(0).getId();
    }

    @Test
    public void testAddWithSameDescription() {
        idAfterUpdate = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withDescription(description)
                                        .withName(anotherName)
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(ANOTHER_OPERATOR_ENUM)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withDefaultMembershipLifeSpan()
                                                        .withExternalId(anotherCorrectGoalId))))
                , ExpectedResult.success()).getAddResults().get(0).getId();
    }

    @Test
    public void testAddWithAnotherExternalIdAndSameOperator() {
        idAfterUpdate = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withDescription(anotherDescription)
                                        .withName(anotherName)
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(OPERATOR_ENUM)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withDefaultMembershipLifeSpan()
                                                        .withExternalId(anotherCorrectGoalId))))
                , ExpectedResult.success()).getAddResults().get(0).getId();
    }

    @Test
    public void testAddWithSameExternalIdAndAnotherOperator() {
        idAfterUpdate = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withDescription(anotherDescription)
                                        .withName(anotherName)
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(ANOTHER_OPERATOR_ENUM)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withDefaultMembershipLifeSpan()
                                                        .withExternalId(correctGoalId))))
                , ExpectedResult.success()).getAddResults().get(0).getId();
    }

    @Test
    public void testAddWithSameRules() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withDescription(anotherDescription)
                                        .withName(anotherName)
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(OPERATOR_ENUM)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withDefaultMembershipLifeSpan()
                                                        .withExternalId(correctGoalId))))
                , ExpectedResult.errors(new Notification(6000, Api5ErrorDetailsJava.OBJECT_EXISTS,
                        path(RetargetingListAddItemMap.RULES))));
    }

    @Test
    public void testAddWithSameRuleItemPlusAnotherOne() {
        idAfterUpdate = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withDescription(anotherDescription)
                                        .withName(anotherName)
                                        .withRules(new RetargetingListRuleItemMap()
                                                        .withOperator(OPERATOR_ENUM)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withDefaultMembershipLifeSpan()
                                                                .withExternalId(correctGoalId)),
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(ANOTHER_OPERATOR_ENUM)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withDefaultMembershipLifeSpan()
                                                                .withExternalId(anotherCorrectGoalId))))
                , ExpectedResult.success()).getAddResults().get(0).getId();
    }

    @After
    public void after() {
        if (idAfterUpdate != null) {
            api.userSteps.retargetingListsSteps().delete(idAfterUpdate);
        }
        api.as(LOGIN);
        api.userSteps.retargetingListsSteps().delete(id);
    }
}

