package ru.yandex.autotests.directapi.retargetinglists.add;

import java.util.List;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 28.07.16.
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Проверка корректности вызова с несколькими элементами")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class AddRetargetingListsSomeItemsTest {
    private static long correctGoalId;
    private static long anotherCorrectGoalId;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING36;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        List<Long> goalIds =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL);
        assumeThat("получено больше 1 объекта", goalIds.size(), greaterThan(1));
        correctGoalId = goalIds.get(0);
        anotherCorrectGoalId = goalIds.get(1);
    }

    @Test
    public void testAddWithSomeValidDifferentAddItems() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                        .withDescription("Description " + RandomStringUtils.randomAlphanumeric(5))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withMembershipLifeSpan(6)
                                                        .withExternalId(correctGoalId))),

                                new RetargetingListAddItemMap()
                                        .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                        .withDescription("Description " + RandomStringUtils.randomAlphanumeric(5))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withMembershipLifeSpan(87)
                                                        .withExternalId(correctGoalId))),

                                new RetargetingListAddItemMap()
                                        .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                        .withDescription("Description " + RandomStringUtils.randomAlphanumeric(5))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withMembershipLifeSpan(5)
                                                        .withExternalId(correctGoalId)))),
                ExpectedResult.success(), ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    public void testAddWithSomeValidDifferentRuleItems() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                        .withDescription("Description " + RandomStringUtils.randomAlphanumeric(5))
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withMembershipLifeSpan(2)
                                                                .withExternalId(correctGoalId)),
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withMembershipLifeSpan(15)
                                                                .withExternalId(correctGoalId)),
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withMembershipLifeSpan(90)
                                                                .withExternalId(correctGoalId)))),
                ExpectedResult.success());
    }

    @Test
    public void testAddWithSomeValidDifferentArgumentItems() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                        .withDescription("Description " + RandomStringUtils.randomAlphanumeric(5))
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                                        .withArgumentItems(
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withMembershipLifeSpan(1)
                                                                        .withExternalId(correctGoalId),
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withMembershipLifeSpan(82)
                                                                        .withExternalId(anotherCorrectGoalId),
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withMembershipLifeSpan(13)
                                                                        .withExternalId(correctGoalId)
                                                        ))),
                ExpectedResult.success());

    }


    @Test
    public void testAddWithSomeValidAndInvalidDifferentAddItems() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                        .withDescription("Description " + RandomStringUtils.randomAlphanumeric(5))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(correctGoalId))),

                                new RetargetingListAddItemMap()
                                        .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                        .withDescription("Description " + RandomStringUtils.randomAlphanumeric(5))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withExternalId(correctGoalId))),
                                new RetargetingListAddItemMap()
                                        .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                        .withDescription("Description " + RandomStringUtils.randomAlphanumeric(5))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withMembershipLifeSpan(35)
                                                        .withExternalId(-1)))),
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(5000,
                        Api5ErrorDetailsJava.MEMBERSHIP_LIFESPAN_MUST_BE_SET_FOR_GOAL_AND_SEGMENT,
                        path(RetargetingListAddItemMap.RULES,
                                0,
                                RetargetingListRuleItemMap.ARGUMENTS,
                                0))),
                ExpectedResult.errors(
                        new Notification(5005,
                                Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                path(RetargetingListAddItemMap.RULES,
                                        0,
                                        RetargetingListRuleItemMap.ARGUMENTS,
                                        0,
                                        RetargetingListRuleArgumentItemMap.EXTERNAL_ID)
                        )));
    }

    @Test
    public void testAddWithSomeValidAndInvalidDifferentRuleItems() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                        .withDescription("Description " + RandomStringUtils.randomAlphanumeric(5))
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withMembershipLifeSpan(2)
                                                                .withExternalId(-correctGoalId)),
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withMembershipLifeSpan(15)
                                                                .withExternalId(correctGoalId)),
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withMembershipLifeSpan(90)
                                                                .withExternalId(correctGoalId)))),
                ExpectedResult.errors(new Notification(5005,
                        Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                        path(RetargetingListAddItemMap.RULES,
                                0,
                                RetargetingListRuleItemMap.ARGUMENTS,
                                0,
                                RetargetingListRuleArgumentItemMap.EXTERNAL_ID)
                )));
    }

    @Test
    public void testAddWithSomeValidAndInvalidDifferentArgumentItems() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                        .withDescription("Description " + RandomStringUtils.randomAlphanumeric(5))
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                                        .withArgumentItems(
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withMembershipLifeSpan(-1)
                                                                        .withExternalId(correctGoalId),
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withMembershipLifeSpan(82)
                                                                        .withExternalId(anotherCorrectGoalId),
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withMembershipLifeSpan(13)
                                                                        .withExternalId(-correctGoalId)
                                                        ))),
                ExpectedResult.errors(
                        new Notification("en", 5005,
                                Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(RetargetingListAddItemMap.RULES,
                                        0,
                                        RetargetingListRuleItemMap.ARGUMENTS,
                                        0,
                                        RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN),
                                1,
                                540),
                        new Notification(5005,
                                Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                path(RetargetingListAddItemMap.RULES,
                                        0,
                                        RetargetingListRuleItemMap.ARGUMENTS,
                                        2,
                                        RetargetingListRuleArgumentItemMap.EXTERNAL_ID)
                        )));

    }
}
