package ru.yandex.autotests.directapi.retargetinglists.add.rules;

import com.yandex.direct.api.v5.retargetinglists.*;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Проверка добавления условия подбора области применения FOR_TARGETS_AND_ADJUSTMENTS")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class AddForAdjustmentOnlyPositiveTest {
    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING50;
    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);
    private static final Integer LIFE_SPAN = RetargetingListRuleArgumentItemMap.DEFAULT_MEMBERSHIP_LIFE_SPAN;
    private static long goalId;
    private static long segmentId;
    private static long audienceSegmentId;
    @Rule
    public Trashman trashman = new Trashman(api);
    @Parameterized.Parameter
    public String description;

    @Parameterized.Parameter(1)
    public RetargetingListRuleItemMap[] rules;

    @Parameterized.Parameters(name = "{0}")
    public static Collection data() {
        prepareGoals();
        Object[][] data = new Object[][]{
                {"NONE with goal",
                        new RetargetingListRuleItemMap[]{
                                new RetargetingListRuleItemMap()
                                    .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                    .withArgumentItems(
                                        new RetargetingListRuleArgumentItemMap()
                                            .withExternalId(goalId)
                                            .withMembershipLifeSpan(LIFE_SPAN))}},
                {"NONE with 2 goals",
                        new RetargetingListRuleItemMap[]{
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                        .withArgumentItems(
                                        new RetargetingListRuleArgumentItemMap()
                                                .withExternalId(goalId)
                                                .withMembershipLifeSpan(LIFE_SPAN),
                                        new RetargetingListRuleArgumentItemMap()
                                                .withExternalId(goalId)
                                                .withMembershipLifeSpan(LIFE_SPAN + 1))}},
                {"NONE with goal + NONE with goal",
                        new RetargetingListRuleItemMap[]{
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                        .withArgumentItems(
                                        new RetargetingListRuleArgumentItemMap()
                                                .withExternalId(goalId)
                                                .withMembershipLifeSpan(LIFE_SPAN)),
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                        .withArgumentItems(
                                        new RetargetingListRuleArgumentItemMap()
                                                .withExternalId(goalId)
                                                .withMembershipLifeSpan(LIFE_SPAN + 1))}},
                {"NONE with segment_goal",
                        new RetargetingListRuleItemMap[]{
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                        .withArgumentItems(
                                        new RetargetingListRuleArgumentItemMap()
                                                .withExternalId(segmentId)
                                                .withRandomMembershipLifeSpan())}},
                {"NONE with audience_segment",
                        new RetargetingListRuleItemMap[]{
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                        .withArgumentItems(
                                        new RetargetingListRuleArgumentItemMap()
                                                .withExternalId(audienceSegmentId))}},
                {"NONE with goal + segment_goal",
                        new RetargetingListRuleItemMap[]{
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                        .withArgumentItems(
                                        new RetargetingListRuleArgumentItemMap()
                                                .withExternalId(goalId)
                                                .withRandomMembershipLifeSpan()),
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                        .withArgumentItems(
                                        new RetargetingListRuleArgumentItemMap()
                                                .withExternalId(segmentId)
                                                .withRandomMembershipLifeSpan())}},
                {"NONE with goal + audience_goal",
                        new RetargetingListRuleItemMap[]{
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                        .withArgumentItems(
                                        new RetargetingListRuleArgumentItemMap()
                                                .withExternalId(goalId)
                                                .withRandomMembershipLifeSpan()),
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                        .withArgumentItems(
                                        new RetargetingListRuleArgumentItemMap()
                                                .withExternalId(audienceSegmentId))}},
                {"NONE with goal + segment_goal + audience_goal",
                        new RetargetingListRuleItemMap[]{
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                        .withArgumentItems(
                                        new RetargetingListRuleArgumentItemMap()
                                                .withExternalId(goalId)
                                                .withRandomMembershipLifeSpan()),
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                        .withArgumentItems(
                                        new RetargetingListRuleArgumentItemMap()
                                                .withExternalId(segmentId)
                                                .withRandomMembershipLifeSpan()),
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                        .withArgumentItems(
                                        new RetargetingListRuleArgumentItemMap()
                                                .withExternalId(audienceSegmentId)),}}
        };
        return Arrays.asList(data);
    }

    public static void prepareGoals(){
        goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        segmentId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.SEGMENT).get(0);
        audienceSegmentId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.AUDIENCE_SEGMENT).get(0);
    }

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void testSuccessAddForAdjustmentOnly() {
        AddResponse addResponse = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                        .withDescription("Description" + RandomStringUtils.randomAlphanumeric(5))
                                        .withRules(rules)
                        ),
                ExpectedResult.success());
        assumeThat("добавился 1 элемент", addResponse.getAddResults(), hasSize(1));
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(
                                RetargetingListFieldEnum.ID,
                                RetargetingListFieldEnum.SCOPE
                        )
                        .withSelectionCriteria(
                                new RetargetingListSelectionCriteriaMap()
                                        .withIds(addResponse.getAddResults().get(0).getId())));
        List<RetargetingListGetItem> expected = new ArrayList<>();
        expected.add((RetargetingListGetItem)
                new RetargetingListGetItemMap()
                        .withId(addResponse.getAddResults().get(0).getId())
                        .withScope(RetargetingListScopeEnum.FOR_ADJUSTMENTS_ONLY)
                        .getBean());

        assertThat("получен верный scope", listsGetItems, beanDifferV5(expected));
    }
}
