package ru.yandex.autotests.directapi.retargetinglists.add.rules;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.retargetinglists.AddResponse;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListScopeEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.ArrayList;
import java.util.List;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap.MAX_MEMBERSHIP_LIFE_SPAN_2019;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Проверка добавления условия подбора со всеми типами операторов и целей в одном запросе")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class AddForTargetsAndAdjustmentFullSetOfOperatorsAndGoalTypesTest {
    private static long goalId;
    private static long segmentId;
    private static long audienceSegmentId;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING47;
    private static final String DESCRIPTION = "Description" + RandomStringUtils.randomAlphanumeric(5);
    private static final String NAME = "Name " + RandomStringUtils.randomAlphanumeric(5);
    @ClassRule
    public static final ApiSteps API = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(API);

    @ClassRule
    public static final SemaphoreRule SEMAPHORE = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        API.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        goalId = API.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        segmentId = API.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.SEGMENT).get(0);
        audienceSegmentId = API.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.AUDIENCE_SEGMENT).get(0);
    }

    @Test
    public void testSuccessAddWithDiffOperatorsAndGoals() {
        AddResponse addResponse = API.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withName(NAME)
                                        .withDescription(DESCRIPTION)
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                        .withArgumentItems(
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(goalId)
                                                                        .withDefaultMembershipLifeSpan(),
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(segmentId),
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(audienceSegmentId)),
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                        .withArgumentItems(
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(goalId)
                                                                        .withDefaultMembershipLifeSpan(),
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(segmentId),
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(audienceSegmentId)),
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                                        .withArgumentItems(
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(goalId)
                                                                        .withDefaultMembershipLifeSpan(),
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(segmentId),
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(audienceSegmentId))
                                        )
                        ),
                ExpectedResult.success());
        assumeThat("добавился 1 элемент", addResponse.getAddResults(), hasSize(1));
        List<RetargetingListGetItem> listsGetItems = API.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFullFieldNames()
                        .withSelectionCriteria(
                                new RetargetingListSelectionCriteriaMap()
                                        .withIds(addResponse.getAddResults().get(0).getId())));
        List<RetargetingListGetItem> expected = new ArrayList<>();
        expected.add((RetargetingListGetItem)
                new RetargetingListGetItemMap()
                        .withId(addResponse.getAddResults().get(0).getId())
                        .withIsAvailable(YesNoEnum.YES)
                        .withDescription(DESCRIPTION)
                        .withName(NAME)
                        .withScope(RetargetingListScopeEnum.FOR_TARGETS_AND_ADJUSTMENTS)
                        .withRules(
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                        .withArgumentItems(
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withExternalId(goalId)
                                                        .withDefaultMembershipLifeSpan(),
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withExternalId(segmentId)
                                                        .withMembershipLifeSpan(MAX_MEMBERSHIP_LIFE_SPAN_2019),
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withExternalId(audienceSegmentId)
                                                        .withMembershipLifeSpan(MAX_MEMBERSHIP_LIFE_SPAN_2019)),
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                        .withArgumentItems(
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withExternalId(goalId)
                                                        .withDefaultMembershipLifeSpan(),
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withExternalId(segmentId)
                                                        .withMembershipLifeSpan(MAX_MEMBERSHIP_LIFE_SPAN_2019),
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withExternalId(audienceSegmentId)
                                                        .withMembershipLifeSpan(MAX_MEMBERSHIP_LIFE_SPAN_2019)),
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                        .withArgumentItems(
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withExternalId(goalId)
                                                        .withDefaultMembershipLifeSpan(),
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withExternalId(segmentId)
                                                        .withMembershipLifeSpan(MAX_MEMBERSHIP_LIFE_SPAN_2019),
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withExternalId(audienceSegmentId)
                                                        .withMembershipLifeSpan(MAX_MEMBERSHIP_LIFE_SPAN_2019)))
                        .getBean());

        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(expected));
    }
}
