package ru.yandex.autotests.directapi.retargetinglists.add.rules;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.RetargetingGoal;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.stream.Stream;

/**
 * Created by aliho on 30/10/17
 */
@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Проверка валидации сохранения разных типов целей")
@Issue("https://st.yandex-team.ru/DIRECT-72245")
public class AddRetargetingListsDifferentGoalTypeValidationTest {

    private static final String login = RetargetingListsLogins.LOGIN_RETARGETING7;
    private static final String loginForEcommerceGoals = Logins.LOGIN_WITH_ECOMMERCE_GOALS;

    private static RetargetingGoal[] goalsForLogin;
    private static RetargetingGoal[] goalsForEcommerceLogin;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        goalsForLogin = api.userSteps.retargetingSteps().getRetargetingGoals(login);
        goalsForEcommerceLogin = api.as(Logins.SUPER_LOGIN, loginForEcommerceGoals).userSteps.retargetingSteps().getRetargetingGoals(loginForEcommerceGoals);
    }

    @Test
    @Description("Проверка cоздания условия из трех типов целей SEGMENT + GOAL + AUDIENCE_SEGMENT для пользователя login")
    public void testAddForLoginCorrectGoalIds() {
        long goalIdSegmentType = Stream.of(goalsForLogin).filter(goal -> new RetargetingGoalMap<>(goal).get(RetargetingGoalMap.TYPE).equals(RetargetingGoalType.SEGMENT.toString())).findFirst().get().getGoalID();
        long goalIdGoalType = Stream.of(goalsForLogin).filter(goal -> new RetargetingGoalMap<>(goal).get(RetargetingGoalMap.TYPE).equals(RetargetingGoalType.GOAL.toString())).findFirst().get().getGoalID();
        long goalIdAudienceSegmentType = Stream.of(goalsForLogin).filter(goal -> new RetargetingGoalMap<>(goal).get(RetargetingGoalMap.TYPE).equals(RetargetingGoalType.AUDIENCE_SEGMENT.toString())).findFirst().get().getGoalID();

        api.as(Logins.SUPER_LOGIN, login).userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goalIdSegmentType),
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goalIdGoalType),
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goalIdAudienceSegmentType)
                                        )),
                ExpectedResult.success());
    }

    @Test
    @Description("Проверка cоздания условия из трех типов целей ECOMMERCE(!) + SEGMENT + GOAL для пользователя goalsForEcommerceLogin")
    public void testAddForEcommerceLoginCorrectGoalIds() {
        long goalIdSegmentType = Stream.of(goalsForEcommerceLogin).filter(goal -> new RetargetingGoalMap<>(goal).get(RetargetingGoalMap.TYPE).equals(RetargetingGoalType.SEGMENT.toString())).findFirst().get().getGoalID();
        long goalIdGoalType = Stream.of(goalsForEcommerceLogin).filter(goal -> new RetargetingGoalMap<>(goal).get(RetargetingGoalMap.TYPE).equals(RetargetingGoalType.GOAL.toString())).findFirst().get().getGoalID();
        long goalIdEcommerceType = Stream.of(goalsForEcommerceLogin).filter(goal -> new RetargetingGoalMap<>(goal).get(RetargetingGoalMap.TYPE).equals(RetargetingGoalType.ECOMMERCE.toString())).findFirst().get().getGoalID();

        api.as(Logins.SUPER_LOGIN, loginForEcommerceGoals).userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goalIdSegmentType),
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goalIdGoalType),
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goalIdEcommerceType)
                                        )),
                ExpectedResult.success());
    }

    @Test
    @Description("Проверка cоздания условия из одного типа целей GOAL для пользователя login")
    public void testAddOneGoalForLoginCorrectGoalIds() {
        long goalIdGoalType = Stream.of(goalsForLogin).filter(goal -> new RetargetingGoalMap<>(goal).get(RetargetingGoalMap.TYPE).equals(RetargetingGoalType.GOAL.toString())).findFirst().get().getGoalID();

        api.as(Logins.SUPER_LOGIN, login).userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goalIdGoalType)
                                        )),
                ExpectedResult.success());
    }

    @Test
    @Description("Проверка cоздания условия из одного типа целей ECOMMERCE для пользователя goalsForEcommerceLogin")
    public void testAddOneEcommerceGoalForEcommerceLoginCorrectGoalIds() {
        long goalIdEcommerceType = Stream.of(goalsForEcommerceLogin).filter(goal -> new RetargetingGoalMap<>(goal).get(RetargetingGoalMap.TYPE).equals(RetargetingGoalType.ECOMMERCE.toString())).findAny().get().getGoalID();

        api.as(Logins.SUPER_LOGIN, loginForEcommerceGoals).userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goalIdEcommerceType)
                                        )),
                ExpectedResult.success());
    }

    @Test
    @Description("Проверка cоздания условия из одного типа целей SEGMENT для пользователя login")
    public void testAddOneGoalSegmentForLoginCorrectGoalIds() {
        long goalIdSegmentType = Stream.of(goalsForEcommerceLogin).filter(goal -> new RetargetingGoalMap<>(goal).get(RetargetingGoalMap.TYPE).equals(RetargetingGoalType.SEGMENT.toString())).findFirst().get().getGoalID();

        api.as(Logins.SUPER_LOGIN, loginForEcommerceGoals).userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goalIdSegmentType)
                                        )),
                ExpectedResult.success());
    }

    @Test
    @Description("Проверка cоздания условия из одного типа целей AUDIENCE_SEGMENT для пользователя login")
    public void testAddOneGoalAudienceSegmentForLoginCorrectGoalIds() {
        long goalIdAudienceSegmentType = Stream.of(goalsForLogin).filter(goal -> new RetargetingGoalMap<>(goal).get(RetargetingGoalMap.TYPE).equals(RetargetingGoalType.AUDIENCE_SEGMENT.toString())).findFirst().get().getGoalID();

        api.as(Logins.SUPER_LOGIN, login).userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goalIdAudienceSegmentType)
                                        )),
                ExpectedResult.success());
    }
}
