package ru.yandex.autotests.directapi.retargetinglists.add.rules;

import com.yandex.direct.api.v5.retargetinglists.*;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 24/02/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.ADD)
@Description("Проверка диапазона значений поля MembershipLifespan")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class AddRetargetingListsMembershipLifespanPositiveTest {
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING44;
    private static Long goalId;
    private static Long segmentId;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter
    public Integer lifespan;

    @Parameterized.Parameter(1)
    public Long externalId;

    @Parameterized.Parameters(name = "MembershipLifespan - {0}")
    public static Collection data() {
        prepareGoals();
        Object[][] data = new Object[][]{
                {RetargetingListRuleArgumentItemMap.MIN_MEMBERSHIP_LIFE_SPAN, goalId},
                {RetargetingListRuleArgumentItemMap.MAX_MEMBERSHIP_LIFE_SPAN_2019, goalId},
                {RetargetingListRuleArgumentItemMap.MAX_MEMBERSHIP_LIFE_SPAN_2019/2, goalId},
                {RetargetingListRuleArgumentItemMap.MIN_MEMBERSHIP_LIFE_SPAN, segmentId},
                {RetargetingListRuleArgumentItemMap.MAX_MEMBERSHIP_LIFE_SPAN_2019, segmentId},
                {RetargetingListRuleArgumentItemMap.MAX_MEMBERSHIP_LIFE_SPAN_2019/2, segmentId}
        };
        return Arrays.asList(data);
    }

    public static void prepareGoals(){
        goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        segmentId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.SEGMENT).get(0);
    }

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(
                                RetargetingListFieldEnum.ID
                        ));
        api.userSteps.retargetingListsSteps().deleteByIds(
                LOGIN, listsGetItems.stream().map(RetargetingListGetItem::getId).collect(Collectors.toList())
        );
    }

    @Test
    public void testValidLifespan() {
        AddResponse addResponse = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withMembershipLifeSpan(lifespan)
                                                        .withExternalId(externalId)))
                , ExpectedResult.success());
        assumeThat("добавился 1 элемент", addResponse.getAddResults(), hasSize(1));
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(
                                RetargetingListFieldEnum.ID,
                                RetargetingListFieldEnum.RULES
                        )
                        .withSelectionCriteria(
                                new RetargetingListSelectionCriteriaMap()
                                        .withIds(addResponse.getAddResults().get(0).getId())));
        List<RetargetingListGetItem> expected = new ArrayList<>();
        int expectedLifespan = (segmentId.equals(externalId)) ?
                RetargetingListRuleArgumentItemMap.MAX_MEMBERSHIP_LIFE_SPAN_2019 : lifespan;
        expected.add((RetargetingListGetItem)
                new RetargetingListGetItemMap()
                        .withId(addResponse.getAddResults().get(0).getId())
                        .withRules(
                                new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                        .withArgumentItems(
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withExternalId(externalId)
                                                        .withMembershipLifeSpan(expectedLifespan)
                        ))
                        .getBean());

        assertThat("получен верный lifespan", listsGetItems, beanDifferV5(expected));

    }
}

