package ru.yandex.autotests.directapi.retargetinglists.delete;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.RetargetingConditionsRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 02/03/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.DELETE)
@Description("Проверка верного удаления из базы методом Delete")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class DeleteRetargetingListsAndCheckDBTest {
    private static long correctGoalId;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING32;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;
    private static Long id;

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        correctGoalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        id = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(correctGoalId);
        RetargetingConditionsRecord retargetingConditionsRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).retargetingConditionSteps().getRetargeingConditionByRetCondId(id);
        assumeThat("в базу записался объект", retargetingConditionsRecord, notNullValue());
        api.userSteps.retargetingListsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(id)),
                ExpectedResult.success()
        );
    }

    @Test
    public void testDeleteRetargetingConditionsSuccess() {
        RetargetingConditionsRecord retargetingConditionsRecord = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .retargetingConditionSteps().getRetargeingConditionByRetCondId(id);
        assumeThat("в базе найден объект", retargetingConditionsRecord, notNullValue());
        assertThat("объект удалился из базы", retargetingConditionsRecord.getIsDeleted(), equalTo(1));
    }
}
