package ru.yandex.autotests.directapi.retargetinglists.delete;

import com.yandex.direct.api.v5.retargetinglists.AddResponse;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.DELETE)
@Description("Проверка удаления правил разных типов")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class DeleteRetargetingListsDiffTypesOfRulesTest {
    private static long goalId;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING31;
    private AddResponse addResponse;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public RetargetingListRuleOperatorEnum operator;

    @Parameterized.Parameters(name = "{0}")
    public static Collection data() {
        Object[][] data = new Object[][]{
                {"ANY", RetargetingListRuleOperatorEnum.ANY},
                {"ALL", RetargetingListRuleOperatorEnum.ALL},
                {"NONE", RetargetingListRuleOperatorEnum.NONE}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
       }

    @Before
    public void addRetargetingLists() {
        goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        addResponse = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                        .withDescription("Description" + RandomStringUtils.randomAlphanumeric(5))
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(operator)
                                                        .withArgumentItems(
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(goalId)
                                                                        .withRandomMembershipLifeSpan())
                                        )
                        ),
                ExpectedResult.success());
        assumeThat("добавился 1 элемент", addResponse.getAddResults(), hasSize(1));
    }

    @Test
    public void testSuccessDelete() {
        api.userSteps.retargetingListsSteps()
                .shouldGetResultOnDelete(
                        new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(addResponse.getAddResults().get(0).getId())), ExpectedResult.success());
    }
}
