package ru.yandex.autotests.directapi.retargetinglists.delete;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.DELETE)
@Description("Проверка ограничения поля Ids")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class DeleteRetargetingListsIdsLimitTest {
    private static long correctGoalId;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING30;
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        correctGoalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
    }

    @Test
    public void moreThanMaxIdsInSelectionCriteria() {
        id = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(correctGoalId);
        Long[] ids = new Long[DeleteRequestMap.MAX_AMOUNT_OF_IDS_IN_DELETE_REQUEST + 1];
        Arrays.fill(ids, id);
        api.userSteps.retargetingListsSteps().expectErrorOnDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(ids)
                        ),
                new Api5Error(4001,
                        Api5ErrorDetailsJava.ENABLE_DELETE_NO_MORE_RETARGETING_LISTS_FOR_OPERATION,
                        DeleteRequestMap.MAX_AMOUNT_OF_IDS_IN_DELETE_REQUEST)
        );
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void maxIdsInSelectionCriteria() {
        int length = DeleteRequestMap.MAX_AMOUNT_OF_IDS_IN_DELETE_REQUEST;
        id = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(correctGoalId);
        Long[] ids = new Long[length];
        Arrays.fill(ids, id);

        ExpectedResult[] results = new ExpectedResult[length];
        for (int i = 0; i < results.length; i++) {
            results[i] = ExpectedResult.errors(new Notification(9800,
                    Api5ErrorDetailsJava.RETARGETING_LISTS_ID_SHOULD_BE_ONCE_IN_REQUEST,
                    path(DeleteRequestMap.SELECTION_CRITERIA, RetargetingListSelectionCriteriaMap.IDS, i)));
        }

        api.userSteps.retargetingListsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(ids)
                        ),
                results
        );
    }
}
