package ru.yandex.autotests.directapi.retargetinglists.delete;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.DELETE)
@Description("Проверка работы метода с невалидными Ids")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class DeleteRetargetingListsInvalidIdsTest {
    private static long correctGoalId;
    private static final String LOGIN1 = RetargetingListsLogins.LOGIN_RETARGETING29;
    private static long anotherClientCorrectGoalId;
    private static final String LOGIN2 = RetargetingListsLogins.LOGIN_RETARGETING27;
    private static Long deletedId;
    private static Long anotherClientId;
    private static long nonExistId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN1);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN1);
    }

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long id;

    @Parameterized.Parameter(2)
    public ExpectedResult[] expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Iterable<Object[]> data() {
        prepareData();
        return Arrays.asList(new Object[][]{
                {"Нулевой Id", 0L,
                        new ExpectedResult[]{
                                ExpectedResult.errors(
                                        new Notification(5005,
                                                Api5ErrorDetailsJava.ID_MUST_BE_POSITIVE_INTEGER
                                        ))}},
                {"Отрицательный Id", -1L,
                        new ExpectedResult[]{
                                ExpectedResult.errors(
                                        new Notification(5005,
                                                Api5ErrorDetailsJava.ID_MUST_BE_POSITIVE_INTEGER
                                        ))}},
                {"Несуществующий Id", nonExistId,
                        new ExpectedResult[]{
                                ExpectedResult.errors(
                                        new Notification(8800))}},
                {"Удаленный Id", deletedId,
                        new ExpectedResult[]{
                                ExpectedResult.errors(
                                        new Notification(8800))}},
                {"Чужой Id", anotherClientId,
                        new ExpectedResult[]{
                                ExpectedResult.errors(
                                        new Notification(8800))}},
        });
    }


    private static void prepareData() {
        correctGoalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN1, RetargetingGoalType.GOAL).get(0);

        deletedId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(correctGoalId);
        api.userSteps.retargetingListsSteps().delete(deletedId);

        nonExistId = deletedId + 1000;

        api.as(LOGIN2);
        anotherClientCorrectGoalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN2, RetargetingGoalType.GOAL).get(0);
        anotherClientId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(anotherClientCorrectGoalId);
        api.as(LOGIN1);
    }


    @Test
    public void deleteWithInvalidId() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(id)),
                expectedResult
        );
    }
}
