package ru.yandex.autotests.directapi.retargetinglists.delete;

import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.DeleteRequestMap;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.DELETE)
@Description("Валидация JSON-запроса при удалении")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class DeleteRetargetingListsJsonValidationTest {
    private static final Long ID = 123L;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING27;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void arrayInSelectionCriteriaField() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(StringUtils.capitalize(IdsCriteriaMap.IDS), ID);
        request.put(StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA), new Object[]{selectionCriteria});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.DELETE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(DeleteRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    public void notAnArrayInIdsField() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(StringUtils.capitalize(IdsCriteriaMap.IDS), 0l);
        request.put(StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.DELETE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }

    @Test
    public void stringInIdsArray() {
        String value = "WrongId";
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(StringUtils.capitalize(IdsCriteriaMap.IDS), new String[]{value});
        request.put(StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.DELETE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }

    @Test
    public void emptyInIdsArray() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(StringUtils.capitalize(IdsCriteriaMap.IDS), new Integer[]{});
        request.put(StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.DELETE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS),
                        1));
    }

    @Test
    public void arrayInIdsArray() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(StringUtils.capitalize(IdsCriteriaMap.IDS), new Long[][]{new Long[]{0l}});
        request.put(StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.DELETE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }
}
