package ru.yandex.autotests.directapi.retargetinglists.delete;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.DeleteRequestMap;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.DELETE)
@Description("Проверка обязательности полей")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class DeleteRetargetingListsMandatoryFieldsTest {
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING29;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void testDeleteWithoutIds() {
        api.userSteps.retargetingListsSteps().expectErrorOnDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap())
                , new Api5Error(8000
                        , Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE
                        , path(IdsCriteriaMap.IDS)));
    }

    @Test
    public void testDeleteWithoutSelectionCriteria() {
        api.userSteps.retargetingListsSteps().expectErrorOnDelete(
                new DeleteRequestMap()
                , new Api5Error(8000
                        , Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE
                        , path(DeleteRequestMap.SELECTION_CRITERIA))
        );
    }
}
