package ru.yandex.autotests.directapi.retargetinglists.delete;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.DELETE)
@Description("Проверка корректности работы SOAP вызова")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class DeleteRetargetingListsSoapTest {
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING27;
    private static Long correctGoalId;
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.SOAP).version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        correctGoalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        id = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(correctGoalId);
    }

    @Test
    @Description("Валидный запрос на удаление условия подбора аудитории")
    public void successDeleteTest() {
        api.userSteps.retargetingListsSteps()
                .shouldGetResultOnDelete(
                        new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(id)), ExpectedResult.success());
    }

    @Test
    @Description("Пустой запрос на удаление объявления")
    public void emptyRequest() {
        api.userSteps.retargetingListsSteps().expectErrorOnDelete(new DeleteRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(DeleteRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Пустое поле SelectionCriteria в запросе на удаление объявления")
    public void emptySelectionCriteria() {
        api.userSteps.retargetingListsSteps().expectErrorOnDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds()),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(DeleteRequestMap.SELECTION_CRITERIA)));
    }
}
