package ru.yandex.autotests.directapi.retargetinglists.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListGetItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThanOrEqualTo;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 06.09.16.
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.GET)
@Description("Проверка значения поля IsAvailable")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class GetIsAvailableTest {

    private static long goal1;
    private static long goal2;
    private static Long retargetingListsId;
    private static int shard;
    private static final String NAME = RandomUtils.getString(10);
    private static final String DESCRIPTION = RandomUtils.getString(10);
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING3;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public int isAccessible1;

    @Parameterized.Parameter(1)
    public int isAccessible2;

    @Parameterized.Parameter(2)
    public YesNoEnum expectedIsAvailable;

    @Parameterized.Parameters(name = "is_acessible goal1 = {0}, goal2 = {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {1, 1, YesNoEnum.YES},
                {1, 0, YesNoEnum.NO},
                {0, 1, YesNoEnum.NO},
                {0, 0, YesNoEnum.NO},
        });
    }

    @BeforeClass
    public static void prepare() {
        api.as(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        List<Long> goalIds =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL);
        assumeThat("у пользователя больше одной цели", goalIds.size(), greaterThanOrEqualTo(2));
        goal1 = goalIds.get(0);
        goal2 = goalIds.get(1);
        List<Long> idList = api.userSteps.retargetingListsSteps().add(new AddRequestMap()
                .withRetargetingLists(
                        new RetargetingListAddItemMap()
                                .withDescription(DESCRIPTION)
                                .withName(NAME)
                                .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goal1)),
                                        new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goal2)))));
        assumeThat("добавился один объект", idList, iterableWithSize(1));
        retargetingListsId = idList.get(0);
    }

    @Test
    public void testGetIsAvailable() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard).retargetingGoalsSteps()
                .setIsAccessible(retargetingListsId, goal1, isAccessible1);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).retargetingGoalsSteps()
                .setIsAccessible(retargetingListsId, goal2, isAccessible2);
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.IS_AVAILABLE)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(retargetingListsId)));
        RetargetingListGetItem expected =
                (RetargetingListGetItem) new RetargetingListGetItemMap().withIsAvailable(expectedIsAvailable).getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Arrays.asList(expected)));
    }
}
