package ru.yandex.autotests.directapi.retargetinglists.get;

import java.util.List;
import java.util.TreeMap;

import javax.xml.ws.handler.MessageContext;

import com.sun.xml.ws.developer.WSBindingProvider;
import com.yandex.direct.api.v5.retargetinglists.ApiException;
import com.yandex.direct.api.v5.retargetinglists.GetRequest;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListsPort;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListSelectionCriteriaMap;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.rules.ApiSteps.USE_OPERATOR_UNITS_TRUE;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.GET)
@Description("Тест проверяет, что для агентства учитываются настройки баллов на главном представителе")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetRetargetingListAgencyRepUnitTest {
    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static final String AGENCY_CHIEF_REP = Logins.AGENCY_YE_DEFAULT;
    private static final String AGENCY_REP = Logins.AGENCY_YE_DEFAULT_REP_2;
    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(AGENCY_REP);
    private static final String AGENCY_ANY_SUBCLIENT = Logins.SUBCLIENT_SHARD2;
    private static final Long CHIEF_REP_UNITS = 10000100L;
    private static final Long REP_UNITS = CHIEF_REP_UNITS + 1000;
    @Rule
    public Trashman trashman = new Trashman(api);

    private static void setUserApiUnitsDailyLimit(String login, Long amount) {
        final DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps();
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);
        long uid = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(login).getPassportID());
        jooqDbSteps.useShard(shard).usersApiOptionsSteps().setUserApiUnitsDailyLimit(uid, amount);
    }

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY_CHIEF_REP);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY_REP);
        setUserApiUnitsDailyLimit(AGENCY_REP, REP_UNITS);
        setUserApiUnitsDailyLimit(AGENCY_CHIEF_REP, CHIEF_REP_UNITS);
    }

    @Test
    public void checkUnitsLimitIsFromChiefRep() throws ApiException {
        api.useOperatorUnits(USE_OPERATOR_UNITS_TRUE);
        final RetargetingListsPort retargetingListsPort =
                api.userSteps.soapClientV5().retargetingListsService(AGENCY_ANY_SUBCLIENT);
        retargetingListsPort.get((GetRequest) new GetRequestMap().withSelectionCriteria(
                new RetargetingListSelectionCriteriaMap().withIds(1235L)
        ).withFieldNames(RetargetingListFieldEnum.NAME).getBean());


        WSBindingProvider bp = (WSBindingProvider) retargetingListsPort;
        TreeMap responseHeaders = (TreeMap) bp.getResponseContext().get(MessageContext.HTTP_RESPONSE_HEADERS);

        String unitsHeader = "Units";
        assumeThat("Header Units содержится в ответе", responseHeaders.containsKey(unitsHeader),
                equalTo(true));
        String unitsStats = ((List) responseHeaders.get(unitsHeader)).get(0).toString();
        final String[] units = unitsStats.split("/");
        Long limit = Long.parseLong(units[2]);
        assertThat("Header Units значение лимита баллов в ручную установленное на главного представителя агентства", limit, equalTo(
                CHIEF_REP_UNITS));
    }
}
