package ru.yandex.autotests.directapi.retargetinglists.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListScopeEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListTypeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListGetItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.yandex.direct.api.v5.general.AdGroupTypesEnum.MOBILE_APP_AD_GROUP;
import static com.yandex.direct.api.v5.general.AdGroupTypesEnum.TEXT_AD_GROUP;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 02/03/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.GET)
@Description("Проверка фильтрации метода по FieldNames")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetRetargetingListsFieldNamesTest {
    private static long correctGoalId;
    private static Long retargetingListsId;
    private static final String NAME = RandomUtils.getString(10);
    private static final String DESCRIPTION = RandomUtils.getString(10);
    private static final RetargetingListRuleOperatorEnum OPERATOR_ENUM
            = RetargetingListRuleOperatorEnum.values()[RandomUtils
            .getRandomInteger(0, RetargetingListRuleOperatorEnum.values().length - 1)];
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING34;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        correctGoalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        List<Long> idList = api.userSteps.retargetingListsSteps().add(new AddRequestMap()
                .withRetargetingLists(
                        new RetargetingListAddItemMap()
                                .withDescription(DESCRIPTION)
                                .withName(NAME)
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(OPERATOR_ENUM)
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withDefaultMembershipLifeSpan()
                                                .withExternalId(correctGoalId)))));
        assumeThat("добавился один объект", idList, iterableWithSize(1));
        retargetingListsId = idList.get(0);
    }

    @Test
    public void testGetId() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(retargetingListsId)));
        RetargetingListGetItem expected =
                (RetargetingListGetItem) new RetargetingListGetItemMap().withId(retargetingListsId).getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Arrays.asList(expected)));
    }

    @Test
    public void testGetDescription() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.DESCRIPTION)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(retargetingListsId)));
        RetargetingListGetItem expected =
                (RetargetingListGetItem) new RetargetingListGetItemMap().withDescription(DESCRIPTION).getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Arrays.asList(expected)));
    }

    @Test
    public void testGetName() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.NAME)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(retargetingListsId)));
        RetargetingListGetItem expected =
                (RetargetingListGetItem) new RetargetingListGetItemMap().withName(NAME).getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Arrays.asList(expected)));
    }

    @Test
    public void testGetIsAvailable() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.IS_AVAILABLE)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(retargetingListsId)));
        RetargetingListGetItem expected =
                (RetargetingListGetItem) new RetargetingListGetItemMap().withIsAvailable(YesNoEnum.YES).getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Arrays.asList(expected)));
    }

    @Test
    public void testGetRules() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.RULES)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(retargetingListsId)));
        RetargetingListGetItem expected = (RetargetingListGetItem) new RetargetingListGetItemMap().withRules(
                new RetargetingListRuleItemMap()
                        .withOperator(OPERATOR_ENUM)
                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                .withExternalId(correctGoalId)
                                .withDefaultMembershipLifeSpan())
        ).getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Arrays.asList(expected)));
    }

    @Test
    public void testGetTwoFields() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.NAME, RetargetingListFieldEnum.DESCRIPTION)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(retargetingListsId)));
        RetargetingListGetItem expected = (RetargetingListGetItem) new RetargetingListGetItemMap()
                .withName(NAME)
                .withDescription(DESCRIPTION)
                .getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Arrays.asList(expected)));
    }

    @Test
    public void testGetScope() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.SCOPE)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(retargetingListsId)));
        RetargetingListGetItem expected = (RetargetingListGetItem)
                new RetargetingListGetItemMap()
                        .withScope(RetargetingListScopeEnum.FOR_TARGETS_AND_ADJUSTMENTS).getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Arrays.asList(expected)));
    }

    @Test
    public void testGetFull() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.values())
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(retargetingListsId)));
        RetargetingListGetItem expected = (RetargetingListGetItem) new RetargetingListGetItemMap()
                .withId(retargetingListsId)
                .withName(NAME)
                .withDescription(DESCRIPTION)
                .withIsAvailable(YesNoEnum.YES)
                .withScope(RetargetingListScopeEnum.FOR_TARGETS_AND_ADJUSTMENTS)
                .withAvailableForTargetsInAdGroupTypes(Arrays.asList(TEXT_AD_GROUP, MOBILE_APP_AD_GROUP))
                .withType(RetargetingListTypeEnum.RETARGETING)
                .withRules(
                        new RetargetingListRuleItemMap()
                                .withOperator(OPERATOR_ENUM)
                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                        .withExternalId(correctGoalId)
                                        .withDefaultMembershipLifeSpan()))
                .getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Arrays.asList(expected)));
    }

}
