package ru.yandex.autotests.directapi.retargetinglists.get;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static org.hamcrest.Matchers.emptyIterable;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 02/03/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.GET)
@Description("Проверка получения условий по Id")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetRetargetingListsIdsTest {
    private static long correctGoalId1;
    private static long correctGoalId2;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING33;
    private static String rand = RandomStringUtils.randomAlphanumeric(5);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        correctGoalId1 = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        correctGoalId2 = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
    }

    @Test
    public void testGetByNegativeId() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(-1L)));
        assertThat("Get вернул пустой список", listsGetItems, emptyIterable());
    }

    @Test
    public void testGetByZeroId() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(0L)));
        assertThat("Get вернул пустой список", listsGetItems, emptyIterable());
    }

    @Test
    public void testGetByUnexistingId() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(1L)));
        assertThat("Get вернул пустой список", listsGetItems, emptyIterable());
    }

    @Test
    public void testGetByExistingIdTwice() {
        Long id = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(correctGoalId1);
        RetargetingListGetItem expected = (RetargetingListGetItem) new RetargetingListGetItemMap().withId(id).getBean();
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(id, id)));
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Arrays.asList(expected)));
    }

    @Test
    public void testGetByTwoExistingIds() {
        List<Long> idList = api.userSteps.retargetingListsSteps().add(new AddRequestMap()
                .withRetargetingLists(new RetargetingListAddItemMap()
                                .withName("Name" + rand)
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withRandomMembershipLifeSpan()
                                                .withExternalId(correctGoalId1)))
                        , new RetargetingListAddItemMap()
                                .withName("Another name" + rand)
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withRandomMembershipLifeSpan()
                                                .withExternalId(correctGoalId2))))
        );

        assumeThat("добавилось два объекта", idList, iterableWithSize(2));
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(idList.get(0), idList.get(1))));
        List<RetargetingListGetItem> expected = new ArrayList<>();
        expected.add((RetargetingListGetItem) new RetargetingListGetItemMap().withId(idList.get(0)).getBean());
        expected.add((RetargetingListGetItem) new RetargetingListGetItemMap().withId(idList.get(1)).getBean());

        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(expected));
    }
}
