package ru.yandex.autotests.directapi.retargetinglists.get;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListGetItemMap;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.GET)
@Description("Валидация JSON-запроса для получения retargetingLists")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetRetargetingListsJsonValidationTest {
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING33;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void arrayInSelectionCriteriaField() {
        JSONObject request = new JSONObject();
        Object selectionCriteria = new IdsCriteriaMap()
                .withIds(0L).getBean();
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), new Object[]{selectionCriteria});
        request.put(capitalize(GetRequestMap.FIELD_NAMES),
                new String[]{capitalize(RetargetingListGetItemMap.ID)});
        api.userSteps.retargetingListsSteps().expectErrorOnGet(request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(GetRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    public void notAnArrayInIdsFields() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(IdsCriteriaMap.IDS), 0L);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES),
                new String[]{capitalize(RetargetingListGetItemMap.ID)});
        api.userSteps.retargetingListsSteps().expectErrorOnGet(request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(GetRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }

    @Test
    public void stringInIdsArray() {
        String value = "SomeInvalidValue";
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(IdsCriteriaMap.IDS), new String[]{value});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES),
                new String[]{capitalize(RetargetingListGetItemMap.ID)});
        api.userSteps.retargetingListsSteps().expectErrorOnGet(request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }

    @Test
    public void arrayInIdsArray() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(IdsCriteriaMap.IDS), new Long[][]{new Long[]{0L}});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES),
                new String[]{capitalize(RetargetingListGetItemMap.ID)});
        api.userSteps.retargetingListsSteps().expectErrorOnGet(request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }

    @Test
    public void arrayInPageField() {
        JSONObject request = new JSONObject();
        request.put(capitalize(GetRequestMap.FIELD_NAMES),
                new String[]{capitalize(RetargetingListGetItemMap.ID)});
        Object limitOffset = new LimitOffsetMap()
                .withLimit(0L)
                .withOffset(0L).getBean();
        request.put(capitalize(GetRequestMap.PAGE), new Object[]{limitOffset});
        api.userSteps.retargetingListsSteps().expectErrorOnGet(request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(GetRequestMap.PAGE)));
    }

    @Test
    public void arrayInLimitField() {
        JSONObject request = new JSONObject();
        JSONObject limitOffset = new JSONObject();
        limitOffset.put(capitalize(LimitOffsetMap.LIMIT), new Long[]{0L});
        limitOffset.put(capitalize(LimitOffsetMap.OFFSET), 0L);
        request.put(capitalize(GetRequestMap.FIELD_NAMES),
                new String[]{capitalize(RetargetingListGetItemMap.ID)});
        request.put(capitalize(GetRequestMap.PAGE), limitOffset);
        api.userSteps.retargetingListsSteps().expectErrorOnGet(request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(GetRequestMap.PAGE, LimitOffsetMap.LIMIT)));
    }

    @Test
    public void stringInLimitField() {
        String value = "StringValue";
        JSONObject request = new JSONObject();
        JSONObject limitOffset = new JSONObject();
        limitOffset.put(capitalize(LimitOffsetMap.LIMIT), value);
        limitOffset.put(capitalize(LimitOffsetMap.OFFSET), 0L);
        request.put(capitalize(GetRequestMap.FIELD_NAMES),
                new String[]{capitalize(RetargetingListGetItemMap.ID)});
        request.put(capitalize(GetRequestMap.PAGE), limitOffset);
        api.userSteps.retargetingListsSteps().expectErrorOnGet(request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(GetRequestMap.PAGE, LimitOffsetMap.LIMIT)));
    }

    @Test
    public void arrayInOffsetField() {
        JSONObject request = new JSONObject();
        JSONObject limitOffset = new JSONObject();
        limitOffset.put(capitalize(LimitOffsetMap.LIMIT), 0L);
        limitOffset.put(capitalize(LimitOffsetMap.OFFSET), new Long[]{0L});
        request.put(capitalize(GetRequestMap.FIELD_NAMES),
                new String[]{capitalize(RetargetingListGetItemMap.ID)});
        request.put(capitalize(GetRequestMap.PAGE), limitOffset);
        api.userSteps.retargetingListsSteps().expectErrorOnGet(request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(GetRequestMap.PAGE, LimitOffsetMap.OFFSET)));
    }

    @Test
    public void stringInOffsetField() {
        String value = "StringValue";
        JSONObject request = new JSONObject();
        JSONObject limitOffset = new JSONObject();
        limitOffset.put(capitalize(LimitOffsetMap.LIMIT), 0L);
        limitOffset.put(capitalize(LimitOffsetMap.OFFSET), value);
        request.put(capitalize(GetRequestMap.FIELD_NAMES),
                new String[]{capitalize(RetargetingListGetItemMap.ID)});
        request.put(capitalize(GetRequestMap.PAGE), limitOffset);
        api.userSteps.retargetingListsSteps().expectErrorOnGet(request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(GetRequestMap.PAGE, LimitOffsetMap.OFFSET)));
    }

    @Test
    public void notAnArrayInFieldNamesField() {
        JSONObject request = new JSONObject();
        request.put(capitalize(GetRequestMap.FIELD_NAMES), capitalize(RetargetingListGetItemMap.ID));
        api.userSteps.retargetingListsSteps().expectErrorOnGet(request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(GetRequestMap.FIELD_NAMES)));
    }
}

