package ru.yandex.autotests.directapi.retargetinglists.get;

import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.AddResponse;
import com.yandex.direct.api.v5.retargetinglists.GetResponse;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.List;

import static ch.lambdaj.Lambda.extractProperty;
import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.GET)
@Description("Проверка логики полей Limit и Offset в Page")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetRetargetingListsPageTest {
    private static long goalId1;
    private static long goalId2;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING17;
    private static List<Long> ids;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.SOAP);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        List<Long> goalIds = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL);
        assumeThat("у клиента должно быть > 1 цели", goalIds.size(), greaterThan(1));
        goalId1 = goalIds.get(0);
        goalId2 = goalIds.get(1);
        AddResponse addResponse = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(new RetargetingListRuleArgumentItemMap()
                                                .withMembershipLifeSpan(6)
                                                .withExternalId(goalId1)),

                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(new RetargetingListRuleArgumentItemMap()
                                                .withMembershipLifeSpan(87)
                                                .withExternalId(goalId1)),
                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(new RetargetingListRuleArgumentItemMap()
                                                .withMembershipLifeSpan(88)
                                                .withExternalId(goalId1)),

                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(new RetargetingListRuleArgumentItemMap()
                                                .withMembershipLifeSpan(5)
                                                .withExternalId(goalId2))),
                ExpectedResult.success(), ExpectedResult.success(), ExpectedResult.success(), ExpectedResult.success());
        ids = extractProperty(addResponse.getAddResults(), RetargetingListGetItemMap.ID);
    }


    @Test
    public void getHead() {
        List<RetargetingListGetItem> retargetingLists = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ids.get(0), ids.get(1), ids.get(2), ids.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)
                                        .withOffset(0L)));
        List<Long> gotids = extractProperty(retargetingLists, RetargetingListGetItemMap.ID);
        assertThat("вернулся правильный набор retargetingLists", gotids, equalTo(Arrays.asList(ids.get(0), ids.get(1))));
    }

    @Test
    public void getBody() {
        List<RetargetingListGetItem> retargetingLists = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ids.get(0), ids.get(1), ids.get(2), ids.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)
                                        .withOffset(1L)));
        List<Long> gotids = extractProperty(retargetingLists, RetargetingListGetItemMap.ID);
        assertThat("вернулся правильный набор retargetingLists", gotids, equalTo(Arrays.asList(ids.get(1), ids.get(2))));
    }

    @Test
    public void getTail() {
        List<RetargetingListGetItem> retargetingLists = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ids.get(0), ids.get(1), ids.get(2), ids.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)
                                        .withOffset(2L)));
        List<Long> gotids = extractProperty(retargetingLists, RetargetingListGetItemMap.ID);
        assertThat("вернулся правильный набор retargetingLists", gotids,
                 equalTo(Arrays.asList(ids.get(2), ids.get(3))));
    }

    @Test
    public void getPartOfTail() {
        List<RetargetingListGetItem> retargetingLists = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ids.get(0), ids.get(1), ids.get(2), ids.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)
                                        .withOffset(3L)));
        List<Long> gotids = extractProperty(retargetingLists, RetargetingListGetItemMap.ID);
        assertThat("вернулся правильный набор retargetingLists", gotids, equalTo(Arrays.asList(ids.get(3))));
    }

    @Test
    public void getOverTail() {
        List<RetargetingListGetItem> retargetingLists = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ids.get(0), ids.get(1), ids.get(2), ids.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)
                                        .withOffset(4L)));
        assertThat("вернулся правильный набор retargetingLists", retargetingLists, hasSize(0));
    }

    @Test
    public void onlyLimit() {
        List<RetargetingListGetItem> retargetingLists = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ids.get(0), ids.get(1), ids.get(2), ids.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)));
        List<Long> gotids = extractProperty(retargetingLists, RetargetingListGetItemMap.ID);
        assertThat("вернулся правильный набор retargetingLists", gotids, equalTo(Arrays.asList(ids.get(0), ids.get(1))));
    }

    @Test
    public void onlyOffset() {
        List<RetargetingListGetItem> retargetingLists = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ids.get(0), ids.get(1), ids.get(2), ids.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withOffset(2L)));
        List<Long> gotids = extractProperty(retargetingLists, RetargetingListGetItemMap.ID);
        assertThat("вернулся правильный набор retargetingLists", gotids, equalTo(Arrays.asList(ids.get(2), ids.get(3))));
    }

    @Test
    public void zeroLimit() {
        api.userSteps.retargetingListsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ids.get(0), ids.get(1), ids.get(2), ids.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(0L)),
                new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0));
    }

    @Test
    public void negativeLimit() {
        api.userSteps.retargetingListsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ids.get(0), ids.get(1), ids.get(2), ids.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(-1L)),
                new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0));
    }

    @Test
    public void maxLimit() {
        List<RetargetingListGetItem> retargetingLists = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ids.get(0), ids.get(1), ids.get(2), ids.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(LimitOffsetMap.LIMIT_MAX_LENGTH)));
        List<Long> gotids = extractProperty(retargetingLists, RetargetingListGetItemMap.ID);
        assertThat("вернулся правильный набор retargetingLists", gotids,
                equalTo(Arrays.asList(ids.get(0), ids.get(1), ids.get(2), ids.get(3))));
    }

    @Test
    public void overMaxLimit() {
        api.userSteps.retargetingListsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ids.get(0), ids.get(1), ids.get(2), ids.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(LimitOffsetMap.LIMIT_MAX_LENGTH + 1)),
                new Api5Error(4002, Api5ErrorDetails.LIMIT_CANNOT_BE_MORE, LimitOffsetMap.LIMIT_MAX_LENGTH));
    }

    @Test
    public void negativeOffset() {
        api.userSteps.retargetingListsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ids.get(0), ids.get(1), ids.get(2), ids.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withOffset(-1L)),
                new Api5Error(4002, Api5ErrorDetails.OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0));
    }

    @Test
    public void checkLimitedByIfLimitDidntWork() {
        GetResponse getResponse = api.userSteps.retargetingListsSteps().retargetingListsGet(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ids.get(0), ids.get(1), ids.get(2), ids.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(4L)));
        assertThat("значение LimitedBy верно", getResponse.getLimitedBy(), nullValue());
    }

    @Test
    public void checkLimitedByIfLimitWorked() {
        GetResponse getResponse = api.userSteps.retargetingListsSteps().retargetingListsGet(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ids.get(0), ids.get(1), ids.get(2), ids.get(3)))
                        .withPage(
                                new LimitOffsetMap()
                                        .withOffset(1L)
                                        .withLimit(2L)));
        assertThat("значение LimitedBy верно", getResponse.getLimitedBy(), equalTo(3L));
    }

    @Test
    public void useLimitAndNotExistRetargetingLists() {
        long nonExistId = ids.get(0) + 1000;
        List<RetargetingListGetItem> retargetingLists = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ids.get(0), ids.get(1), nonExistId))
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)));
        List<Long> gotids = extractProperty(retargetingLists, WebpageFieldEnum.ID.value());
        assertThat("вернулся правильный набор retargetingLists", gotids, equalTo(Arrays.asList(ids.get(0), ids.get(1))));
    }

}
