package ru.yandex.autotests.directapi.retargetinglists.get;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.GET)
@Description("Проверка вызова метода get под ролями")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class GetRetargetingListsRoleTest {
    private static final String CLIENT = RetargetingListsLogins.GET_CLIENT;
    private static final String CLIENT_REP = RetargetingListsLogins.GET_CLIENT_REP;
    private static final String AGENCY = RetargetingListsLogins.GET_AGENCY;
    private static final String AGENCY_REP =  RetargetingListsLogins.GET_AGENCY_REP;
    private static final String SUBCLIENT1 = RetargetingListsLogins.GET_SUBCLIENT1;
    private static final String SUBCLIENT2 = RetargetingListsLogins.GET_SUBCLIENT2;
    private static final String MANAGER = Logins.MANAGER_DEFAULT;
    private static final String SERV_CLIENT = RetargetingListsLogins.GET_SERV_CLIENT;
    private static final String SUPER = Logins.SUPER_LOGIN;
    private static final String SUPER_READER = Logins.SUPER_READER;
    private static final String PLACER = Logins.PLACER;
    private static final String SUPPORT = Logins.SUPPORT;
    private static final String MEDIA = Logins.MEDIA;
    private static final int CORRECT_LIFESPAN = 10;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private List<Long> idList;
    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String loginToAddRetargetingList;

    @Parameterized.Parameter(2)
    public String apiUserLogin;

    @Parameterized.Parameter(3)
    public String login;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Получение условий от имени менеджера", MANAGER, MANAGER, SERV_CLIENT},

                {"Получение условий от имени вешальщика", SUPER, PLACER, CLIENT},

                {"Получение условий от имени саппорта", SUPER, SUPPORT, CLIENT},

                {"Получение условий от имени супера", SUPER, SUPER, CLIENT},

                {"Получение условий от имени медиапланера", SUPER, MEDIA, CLIENT},

                {"Получение условий от имени суперридера", SUPER, SUPER_READER, CLIENT},

                {"Получение условий от имени клиента для самого себя", SUPER, CLIENT, CLIENT},

                {"Получение условий от имени представителя клиента для клиента", SUPER, CLIENT_REP, CLIENT},

                {"Получение условий от имени агенства для субклиента", AGENCY, AGENCY, SUBCLIENT1},

                {"Получение условий от имени представителя агенства для субклиента", AGENCY_REP, AGENCY_REP, SUBCLIENT2},

                {"Получение условий от имени субклиента для самого себя", AGENCY, SUBCLIENT1, SUBCLIENT1}
        });
    }

    @BeforeClass
    public static void clearUnits(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT_REP);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY_REP);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SUBCLIENT1);
    }

    @Before
    public void setup() {
        Long goalId = api.as(login).userSteps.retargetingSteps()
                .getRetargetingGoalIDsByType(login, RetargetingGoalType.GOAL).get(0);
        api.as(loginToAddRetargetingList);
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(login,
                new GetRequestMap()
                        .withFieldNames(
                                RetargetingListFieldEnum.ID,
                                RetargetingListFieldEnum.RULES
                        ));
        Optional<RetargetingListGetItem> existing = listsGetItems.stream().filter(rl ->
                rl.getRules().get(0).getOperator().equals(RetargetingListRuleOperatorEnum.ANY)
                && rl.getRules().get(0).getArguments().get(0).getMembershipLifeSpan().equals(CORRECT_LIFESPAN)
                && rl.getRules().get(0).getArguments().get(0).getExternalId() == goalId
        ).findFirst();
        idList =
                existing.map(retargetingListGetItem -> Collections.singletonList(retargetingListGetItem.getId()))
                        .orElseGet(() -> api.userSteps.retargetingListsSteps().add(
                login,
                new AddRequestMap()
                        .withRetargetingLists(new RetargetingListAddItemMap()
                                .withRandomName()
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withMembershipLifeSpan(CORRECT_LIFESPAN)
                                                .withExternalId(goalId))))
        ));
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(apiUserLogin);
    }

    @Test
    public void getUsingLogin() {
        api.as(apiUserLogin);
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                login,
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(idList.get(0))));
        assertThat("Get вернул ожидаемый объект", listsGetItems, hasSize(1));
    }
}
