package ru.yandex.autotests.directapi.retargetinglists.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListGetItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 02/03/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.GET)
@Description("Общие проверки метода")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class GetRetargetingListsTest {
    private static long correctGoalId;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING16;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long id;

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        List<RetargetingListGetItem> retargetingLists = api.userSteps.retargetingListsSteps().getByLogin(LOGIN);
        assumeThat("у клиента нету RetargetingLists", retargetingLists, hasSize(0));
        correctGoalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        id = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(correctGoalId);
    }

    @Test
    public void testGetSuccess() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(id)));
        RetargetingListGetItem expected = (RetargetingListGetItem) new RetargetingListGetItemMap().withId(id).getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Arrays.asList(expected)));
    }

    @Test
    public void testGetWithoutIds() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()));
        RetargetingListGetItem expected = (RetargetingListGetItem) new RetargetingListGetItemMap().withId(id).getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Arrays.asList(expected)));
    }

    @Test
    public void testGetWithoutSelectionCriteria() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID));
        RetargetingListGetItem expected = (RetargetingListGetItem) new RetargetingListGetItemMap().withId(id).getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Arrays.asList(expected)));
    }

    @Test
    public void testGetWithoutFieldNames() {
        api.userSteps.retargetingListsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap())
                , new Api5Error(8000
                        , Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE
                        , path(GetRequestMap.FIELD_NAMES))
        );
    }

    @Test
    public void testGetWithoutFieldNamesAndSelectionCriteria() {
        api.userSteps.retargetingListsSteps().expectErrorOnGet(
                new GetRequestMap()
                , new Api5Error(8000
                        , Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE
                        , path(GetRequestMap.FIELD_NAMES))
        );
    }
}
