package ru.yandex.autotests.directapi.retargetinglists.get;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListTypeEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListGetItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(RetargetingListsFeatures.GET)
@Description("Проверка получения условий по SelectionCriteria.Types")
@Issue("https://st.yandex-team.ru/DIRECT-86010")
public class GetRetargetingListsTypesTest {
    private static Long idRetargeting;
    private static Long idAudience;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING33;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        long correctGoalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);

        List<Long> ids = api.userSteps.retargetingListsSteps().add(new AddRequestMap()
                .withRetargetingLists(
                        new RetargetingListAddItemMap()
                                .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                .withType(RetargetingListTypeEnum.RETARGETING)
                                .withDescription("Description " + RandomStringUtils.randomAlphanumeric(5))
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withMembershipLifeSpan(RandomUtils.getRandomInteger(1, 90))
                                                .withExternalId(correctGoalId))),
                        new RetargetingListAddItemMap()
                                .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                .withType(RetargetingListTypeEnum.AUDIENCE)
                                .withDescription("Description " + RandomStringUtils.randomAlphanumeric(5))
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withMembershipLifeSpan(RandomUtils.getRandomInteger(1, 90))
                                                .withExternalId(correctGoalId))))
        );

        idRetargeting = ids.get(0);
        idAudience = ids.get(1);

        assumeThat("добавилось два объекта", ids, iterableWithSize(2));
    }

    @Test
    public void testGetByRetargeting() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(idRetargeting, idAudience)
                                .withTypes(RetargetingListTypeEnum.RETARGETING)));

        RetargetingListGetItem expected =
                (RetargetingListGetItem) new RetargetingListGetItemMap().withId(idRetargeting).getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Collections.singletonList(expected)));
    }

    @Test
    public void testGetByAudience() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(idRetargeting, idAudience)
                                .withTypes(RetargetingListTypeEnum.AUDIENCE)));
        RetargetingListGetItem expected =
                (RetargetingListGetItem) new RetargetingListGetItemMap().withId(idAudience).getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Collections.singletonList(expected)));
    }

    @Test
    public void testGetByRetargetingAndAudience() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(idRetargeting, idAudience)
                                .withTypes(RetargetingListTypeEnum.RETARGETING, RetargetingListTypeEnum.AUDIENCE)));

        List<RetargetingListGetItem> expected = new ArrayList<>();
        expected.add((RetargetingListGetItem) new RetargetingListGetItemMap().withId(idRetargeting).getBean());
        expected.add((RetargetingListGetItem) new RetargetingListGetItemMap().withId(idAudience).getBean());

        assertThat("Get вернул ожидаемые объекты", listsGetItems, beanDifferV5(expected));
    }

    @Test
    public void testGetWithoutType() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(idRetargeting, idAudience)));

        List<RetargetingListGetItem> expected = new ArrayList<>();
        expected.add((RetargetingListGetItem) new RetargetingListGetItemMap().withId(idRetargeting).getBean());
        expected.add((RetargetingListGetItem) new RetargetingListGetItemMap().withId(idAudience).getBean());

        assertThat("Get вернул ожидаемые объекты", listsGetItems, beanDifferV5(expected));
    }
}
