package ru.yandex.autotests.directapi.retargetinglists.get;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.RetargetingGoal;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by aliho on 02.11.17.
 */
@Aqua.Test
@Features(RetargetingListsFeatures.GET)
@Description("Проверки метода GET условий с икомерсами целями")
@Issue("https://st.yandex-team.ru/DIRECT-72245")
public class GetRetargetingListsWithEcommerceGoalsTest {
    private static final String loginForEcommerceGoals = Logins.LOGIN_WITH_ECOMMERCE_GOALS;
    private static RetargetingGoal[] goalsForEcommerceLogin;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(loginForEcommerceGoals);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long ecommerceRetargetingListId;

    @BeforeClass
    public static void prepare() {
        goalsForEcommerceLogin = api.as(Logins.SUPER_LOGIN, loginForEcommerceGoals).userSteps.retargetingSteps().getRetargetingGoals(loginForEcommerceGoals);
        long goalIdEcommerceType = Stream.of(goalsForEcommerceLogin).filter(goal -> new RetargetingGoalMap<>(goal).get(RetargetingGoalMap.TYPE).equals(RetargetingGoalType.ECOMMERCE.toString())).findAny().get().getGoalID();

        String name = "Name" + RandomStringUtils.randomAlphabetic(6);
        String description = "Description" + RandomStringUtils.randomAlphabetic(6);
        ecommerceRetargetingListId = api.as(Logins.SUPER_LOGIN, loginForEcommerceGoals).userSteps.retargetingListsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withDescription(description)
                                        .withName(name)
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withDefaultMembershipLifeSpan()
                                                        .withExternalId(goalIdEcommerceType))))
                , ExpectedResult.success()).getAddResults().get(0).getId();

   }

    @Test
    public void testGetSuccessRetargetingConditionsWithEcommerceGoals() {
        List<RetargetingListGetItem> listsGetItems = api.as(Logins.SUPER_LOGIN, loginForEcommerceGoals).userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(ecommerceRetargetingListId)));
        RetargetingListGetItem expected = (RetargetingListGetItem) new RetargetingListGetItemMap().withId(ecommerceRetargetingListId).getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(Arrays.asList(expected)));
    }

}
