package ru.yandex.autotests.directapi.retargetinglists.update;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.UPDATE)
@Description("Проверка корректности работы метода для разных ролей")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class UpdateRetargeingListsRoleNegativeTest {
    private static final String SUBCLIENT1 = RetargetingListsLogins.UPDATE_SUBCLIENT1;
    private static final String SUPER = Logins.SUPER_LOGIN;
    private static final String AGENCY_REP = RetargetingListsLogins.UPDATE_AGENCY_REP;
    private static final String AGENCY = RetargetingListsLogins.UPDATE_AGENCY;
    private static final String CLIENT = RetargetingListsLogins.UPDATE_CLIENT;
    private static final String MANAGER = Logins.MANAGER_DEFAULT;
    private static final String SUPER_READER = Logins.SUPER_READER;
    private static final String MEDIA = Logins.MEDIA;
    private static final int CORRECT_LIFESPAN = 11;
    private Long goalId;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private List<Long> idList;
    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String loginToAddRetargetingList;

    @Parameterized.Parameter(2)
    public String apiUserLogin;

    @Parameterized.Parameter(3)
    public String login;

    @Parameterized.Parameter(4)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {


        return Arrays.asList((Object[][]) new Object[][]{
                {"Добавление условий от имени медиапланера", SUPER, MEDIA, CLIENT, new Api5Error(54)},

                {"Добавление условий от имени суперридера", SUPER, SUPER_READER, CLIENT, new Api5Error(54)},

                {"Добавление условий от имени субклиента для самого себя", AGENCY, SUBCLIENT1, SUBCLIENT1,
                        new Api5Error(54)},

                {"Добавление условий от имени менеджера для клиента", CLIENT, MANAGER, CLIENT,
                        new Api5Error(8800, Api5ErrorDetailsJava.USERNAME_DOES_NOT_EXIST)},

                {"Добавление условий от имени представителя агентства для субклиента на которого нет прав",
                        AGENCY, AGENCY_REP, SUBCLIENT1, new Api5Error(54)},
        });
    }

    @Before
    public void setup() {
        goalId = api.as(login).userSteps.retargetingSteps().getRetargetingGoalIDsByType(login, RetargetingGoalType.GOAL)
                .get(0);
        api.as(loginToAddRetargetingList);
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(login,
                new GetRequestMap()
                        .withFieldNames(
                                RetargetingListFieldEnum.ID,
                                RetargetingListFieldEnum.RULES
                        ));
        Optional<RetargetingListGetItem> existing = listsGetItems.stream().filter(rl ->
                rl.getRules().get(0).getOperator().equals(RetargetingListRuleOperatorEnum.ANY)
                        && rl.getRules().get(0).getArguments().get(0).getMembershipLifeSpan().equals(CORRECT_LIFESPAN)
                        && rl.getRules().get(0).getArguments().get(0).getExternalId() == goalId
        ).findFirst();
        idList =
                existing.map(retargetingListGetItem -> Collections.singletonList(retargetingListGetItem.getId()))
                        .orElseGet(() -> api.userSteps.retargetingListsSteps().add(
                                login,
                                new AddRequestMap()
                                        .withRetargetingLists(new RetargetingListAddItemMap()
                                                .withRandomName()
                                                .withRules(new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withMembershipLifeSpan(CORRECT_LIFESPAN)
                                                                .withExternalId(goalId))))
                        ));
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(apiUserLogin);
    }

    @Test
    public void updateUsingLogin() {
        api.as(apiUserLogin);
        api.userSteps.retargetingListsSteps().expectErrorOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(idList.get(0))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withMembershipLifeSpan(CORRECT_LIFESPAN)
                                                        .withExternalId(goalId)))),
                login,
                expectedError);
    }
}
