package ru.yandex.autotests.directapi.retargetinglists.update;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.UPDATE)
@Description("Проверка корректности работы метода для разных ролей")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class UpdateRetargeingListsRoleTest {
    private static final String MANAGER = Logins.MANAGER_DEFAULT;
    private static final String SUPER = Logins.SUPER_LOGIN;
    private static final String PLACER = Logins.PLACER;
    private static final String SUPPORT = Logins.SUPPORT;
    private static final String SERV_CLIENT = RetargetingListsLogins.UPDATE_SERV_CLIENT;
    private static final String CLIENT = RetargetingListsLogins.UPDATE_CLIENT;
    private static final String CLIENT_REP = RetargetingListsLogins.UPDATE_CLIENT_REP;
    private static final String AGENCY = RetargetingListsLogins.UPDATE_AGENCY;
    private static final String AGENCY_REP = RetargetingListsLogins.UPDATE_AGENCY_REP;
    private static final String SUBCLIENT1 = RetargetingListsLogins.UPDATE_SUBCLIENT1;
    private static final String SUBCLIENT2 = RetargetingListsLogins.UPDATE_SUBCLIENT2;
    private static final String SUBCLIENT3 = RetargetingListsLogins.UPDATE_SUBCLIENT3;

    private static final Api5Error noRights = new Api5Error(54);

    private Long goalId;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private List<Long> idList;
    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String loginToAddRetargetingList;

    @Parameterized.Parameter(2)
    public String apiUserLogin;

    @Parameterized.Parameter(3)
    public String login;

    @Parameterized.Parameter(4)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {

        return Arrays.asList(new Object[][]{
                {"Обновление условий от имени менеджера", MANAGER, MANAGER, SERV_CLIENT, null},

                {"Обновление условий от имени вешальщика", SUPER, PLACER, CLIENT, noRights},

                {"Обновление условий от имени саппорта", SUPER, SUPPORT, CLIENT, null},

                {"Обновление условий от имени супера", SUPER, SUPER, CLIENT, null},

                {"Обновление условий от имени клиента для самого себя", SUPER, CLIENT, CLIENT, null},

                {"Обновление условий от имени представителя клиента для клиента", SUPER, CLIENT_REP, CLIENT, null},

                {"Обновление условий от имени агенства для субклиента", AGENCY, AGENCY, SUBCLIENT1, null},

                {"Обновление условий от имени представителя агенства для субклиента", AGENCY_REP, AGENCY_REP, SUBCLIENT2, null},

                {"Обновление условий от субклиента с правом редактировать для самого себя", AGENCY, SUBCLIENT3, SUBCLIENT3, null},
        });
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT_REP);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY_REP);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SUBCLIENT1);
        goalId = api.as(login).userSteps.retargetingSteps().getRetargetingGoalIDsByType(login, RetargetingGoalType.GOAL).get(0);
        api.as(loginToAddRetargetingList);
        idList = api.userSteps.retargetingListsSteps().add(
                login,
                new AddRequestMap()
                        .withRetargetingLists(new RetargetingListAddItemMap()
                                .withRandomName()
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withRandomMembershipLifeSpan()
                                                .withExternalId(goalId))))
        );
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(apiUserLogin);
    }

    @Test
    public void updateUsingLogin() {
        api.as(apiUserLogin);
        api.userSteps.retargetingListsSteps().expectErrorOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(idList.get(0))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goalId)))),
                login,
                expectedError);
    }
}
