package ru.yandex.autotests.directapi.retargetinglists.update;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 24/02/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.UPDATE)
@Description("Проверка обновления поля Description")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class UpdateRetargetingListsDescriptionTest {
    private static long correctGoalId;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING22;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String initialDescription;

    @Parameterized.Parameter(1)
    public String updatedDescription;

    private List<Long> idList;
    private RetargetingListGetItem expectedGetResponse;

    @Parameterized.Parameters(name = "Initial description - {0}, updated description - {1}")
    public static Collection data() {
        Object[][] data = new Object[][]{
                {null, "Description"},
                {"Description", "Description"},
                {"Description", "Another description"},
                {"Description", null},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        correctGoalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        idList = api.userSteps.retargetingListsSteps().add(new AddRequestMap()
                .withRetargetingLists(
                        new RetargetingListAddItemMap()
                                .withDescription(initialDescription)
                                .withRandomName()
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withRandomMembershipLifeSpan()
                                                .withExternalId(correctGoalId))))
        );
        assumeThat("добавился один объект", idList, iterableWithSize(1));
        expectedGetResponse = api.userSteps.retargetingListsSteps().get(new GetRequestMap()
                .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                        .withIds(idList.get(0)))
                .withFieldNames(RetargetingListFieldEnum.values())
        ).get(0);
        expectedGetResponse = (RetargetingListGetItem)
                new RetargetingListGetItemMap(expectedGetResponse)
                        .withDescription(updatedDescription)
                        .getBean();
    }

    @Test
    public void test() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withRetargetingLists(
                        new RetargetingListUpdateItemMap().withId(idList.get(0))
                                .withDescription(updatedDescription)),
                ExpectedResult.success());

        List<RetargetingListGetItem> getResponse = api.userSteps.retargetingListsSteps().get(new GetRequestMap()
                .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                        .withIds(idList.get(0)))
                .withFieldNames(RetargetingListFieldEnum.values())
        );

        assertThat("обновилось только поле Descripion", getResponse, beanDifferV5(Arrays.asList(expectedGetResponse)));
    }
}

