package ru.yandex.autotests.directapi.retargetinglists.update;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;
import java.util.stream.Collectors;

import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by buhter on 24/02/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.UPDATE)
@Description("Проверка корректности работы метода Update для одинаковых полей/объектов")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class UpdateRetargetingListsExistingItemsTest {
    private static long correctGoalId;
    private static long anotherCorrectGoalId;
    private static final String NAME = "Name";
    private static final String ANOTHER_NAME = "Another Name";
    private static final String DESCRIPTION = "Description";
    private static final String ANOTHER_DESCRIPTION = "Another Description";
    private static final RetargetingListRuleOperatorEnum OPERATOR_ENUM = RetargetingListRuleOperatorEnum.ANY;
    private static final RetargetingListRuleOperatorEnum ANOTHER_OPERATOR_ENUM = RetargetingListRuleOperatorEnum.ALL;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING21;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private List<Long> idList;

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        List<Long> goalIds = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL);
        assumeThat("получено больше 1 объекта", goalIds.size(), greaterThan(1));
        correctGoalId = goalIds.get(0);
        anotherCorrectGoalId = goalIds.get(1);
    }

    @Before
    public void init() {
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new GetRequestMap()
                        .withFieldNames(
                                RetargetingListFieldEnum.ID
                        ));
        api.userSteps.retargetingListsSteps().deleteByIds(
                LOGIN, listsGetItems.stream().map(RetargetingListGetItem::getId).collect(Collectors.toList())
        );

        idList = api.userSteps.retargetingListsSteps().add(new AddRequestMap()
                .withRetargetingLists(
                        new RetargetingListAddItemMap()
                                .withDescription(ANOTHER_DESCRIPTION)
                                .withName(ANOTHER_NAME)
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(ANOTHER_OPERATOR_ENUM)
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withDefaultMembershipLifeSpan()
                                                .withExternalId(anotherCorrectGoalId))),
                        new RetargetingListAddItemMap()
                                .withDescription(DESCRIPTION)
                                .withName(NAME)
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(OPERATOR_ENUM)
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withDefaultMembershipLifeSpan()
                                                .withExternalId(correctGoalId))))
        );
        assumeThat("добавилось два объекта", idList, iterableWithSize(2));
    }

    @Test
    public void testUpdateWithExistingName() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(idList.get(0))
                                        .withName(NAME)
                        )
                , ExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetailsJava.OBJECT_EXISTS,
                        path(RetargetingListUpdateItemMap.NAME))));
    }

    @Test
    public void testUpdateWithExistingDescription() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(idList.get(0))
                                        .withDescription(DESCRIPTION)
                        )
                , ExpectedResult.success());
    }

    @Test
    public void testUpdateWithAnotherExternalIdAndSameOperator() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(idList.get(0))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(OPERATOR_ENUM)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withDefaultMembershipLifeSpan()
                                                        .withExternalId(anotherCorrectGoalId))))
                , ExpectedResult.success());
    }

    @Test
    public void testUpdateWithExistingExternalIdAndAnotherOperator() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(idList.get(0))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(ANOTHER_OPERATOR_ENUM)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withDefaultMembershipLifeSpan()
                                                        .withExternalId(correctGoalId))))
                , ExpectedResult.success());
    }

    @Test
    public void testUpdateWithExistingRules() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(idList.get(0))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(OPERATOR_ENUM)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withDefaultMembershipLifeSpan()
                                                        .withExternalId(correctGoalId))))
                , ExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetailsJava.OBJECT_EXISTS,
                        path(RetargetingListUpdateItemMap.RULES))));
    }

    @Test
    public void testUpdateWithExistingRuleItemPlusAnotherOne() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(idList.get(0))
                                        .withDescription(ANOTHER_DESCRIPTION)
                                        .withName(ANOTHER_NAME)
                                        .withRules(new RetargetingListRuleItemMap()
                                                        .withOperator(OPERATOR_ENUM)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withDefaultMembershipLifeSpan()
                                                                .withExternalId(correctGoalId)),
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(ANOTHER_OPERATOR_ENUM)
                                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                                .withDefaultMembershipLifeSpan()
                                                                .withExternalId(anotherCorrectGoalId))))
                , ExpectedResult.success());
    }
}

