package ru.yandex.autotests.directapi.retargetinglists.update;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.List;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 07.09.16.
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.UPDATE)
@Description("Проверка обновления условий ретаргетинга в обратном порядке")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class UpdateRetargetingListsInReverseOrderTest {

    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING9;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long id1;
    private static long id2;

    private static String nameForId1 = RandomStringUtils.randomAlphabetic(8);
    private static String nameForId2 = RandomStringUtils.randomAlphabetic(8);

    private static String descriptionForId1 = RandomStringUtils.randomAlphabetic(8);
    private static String descriptionForId2 = RandomStringUtils.randomAlphabetic(8);

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void createAd() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        Long segmentId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.SEGMENT).get(0);

        List<Long> ids = api.userSteps.retargetingListsSteps().add(new AddRequestMap()
                .withRetargetingLists(new RetargetingListAddItemMap()
                                .withName(RandomStringUtils.randomAlphabetic(8))
                                .withDescription(descriptionForId1)
                                .withRules(new RetargetingListRuleItemMap()
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withRandomMembershipLifeSpan()
                                                .withExternalId(goalId))
                                        .withOperator(RetargetingListRuleOperatorEnum.ALL)),
                        new RetargetingListAddItemMap()
                                .withName(RandomStringUtils.randomAlphabetic(8))
                                .withDescription(descriptionForId2)
                                .withRules(new RetargetingListRuleItemMap()
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withRandomMembershipLifeSpan()
                                                .withExternalId(segmentId))
                                        .withOperator(RetargetingListRuleOperatorEnum.ALL))));
        id1 = ids.get(0);
        id2 = ids.get(1);
    }

    @Test
    public void updateRetargetingListsInReverseOrder() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(new RetargetingListUpdateItemMap()
                                        .withId(id2)
                                        .withName(nameForId2),
                                new RetargetingListUpdateItemMap()
                                        .withId(id1)
                                        .withName(nameForId1)),
                ExpectedResult.success(), ExpectedResult.success());

        List<RetargetingListGetItem> retargetingListGetItems =
                api.userSteps.retargetingListsSteps().get(new GetRequestMap()
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(id1, id2))
                        .withFieldNames(RetargetingListFieldEnum.ID, RetargetingListFieldEnum.NAME, RetargetingListFieldEnum.DESCRIPTION));

        assertThat("условия ретаргетинга обновились правильно", retargetingListGetItems, beanDifferV5(Arrays.asList(
                new RetargetingListGetItemMap()
                        .withId(id1)
                        .withName(nameForId1)
                        .withDescription(descriptionForId1)
                        .getBean(),
                new RetargetingListGetItemMap()
                        .withId(id2)
                        .withName(nameForId2)
                        .withDescription(descriptionForId2)
                        .getBean()))
        );
    }
}
